                 
#include "yodl.h"

void init ()
{
    int
        i;
    static char
        *default_macname [] =                   /* default macro names */
        {
            "DEFINESYMBOL",
            "INCLUDEFILE",
            "NOEXPAND",
            "RENAMEMACRO",
            "UNDEFINESYMBOL",
            "IFDEF",
            "DEFINEMACRO",
            "CHAR",
            "COMMENT",
            "TYPEOUT",
            "DEFINECHARTABLE",
            "USECHARTABLE",
            "ATEXIT",
            "DUMMY",
            "STARTDEF",
            "ENDDEF",
            "IFEMPTY",
            "UNDEFINEMACRO",
            "NEWCOUNTER",
            "COUNTERVALUE",
            "SETCOUNTER",
            "ADDTOCOUNTER",
            "USECOUNTER",
            "ERROR",
            "IFZERO",
            "PARAGRAPH",
            "SUBST",
            "NOTRANS",
            "CHDIR",
            "IFSTREQUAL",
            "IFSTRSUB",
            "WARNING",
            "NOUSERMACRO",
            "SYSTEM",
            "PIPETHROUGH",
            "UPPERCASE",
            "INCLUDELITERAL",
            "PUSHCHARTABLE",
            "POPCHARTABLE",
            
            NULL,                               /* stopper */
        };
        
                                                /* load default macro names */
    for (i = mac_starter + 1; i < mac_stopper; i++)
    {
        if (! default_macname [i])              /* sanity check */
            error ("internal: table of builtin default macro names corrupt");
        builtin = strtab_add (builtin, &nbuiltin, default_macname [i]);
    }
    
    error_setprogname ("yodl");                  /* for error messages */

    signal (SIGHUP, sighandler);                /* signal handler */
    signal (SIGINT, sighandler);
    signal (SIGQUIT, sighandler);
    signal (SIGTERM, sighandler);
    signal (SIGSEGV, sighandler);

}
