
#include "yodl.h"

void gram_warn (char const *rule, char const *msg, ...)
{
    va_list
        args;
    char
        *buf = lexbuf;
        
    if (! flags.warn)
        return;
        
    if (! buf || ! *buf)
        buf = "<empty>";
    else if (*buf == '\n')
        buf = "<newline>";
        
    va_start (args, msg);
    fprintf (stderr, "yodl warning: %s [near %d],\n"
                     "during %s:\n", 
             cur_input_file, cur_lineno, rule);
    vfprintf (stderr, msg, args);
    fprintf (stderr, "\n(last parsed symbol: `%s')\n", buf);
}
