
#include "yodl.h"

void gram_ifzero ()
{
    char
        *symbol,
	*truelist,
	*falselist;
    int
        slot,
        nr;
                                             /* get symbol, true-, falselist */
    symbol = gram_parlist (builtin [mac_ifzero], 0); 
    message (3, "%s %s\n", builtin [mac_ifzero], str_short (symbol));
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    truelist = gram_parlist (builtin [mac_ifzero], 0);
    
    while (lextok == tok_space ||           /* skip spaces, newlines */
           lextok == tok_newline
	  )
        lexer ();
    
    falselist = gram_parlist (builtin [mac_ifzero], 0);
    
    lexer_pushstr (lexbuf);                 /* push back beyond parlist */
    
    if (! symbol || ! *symbol)              /* no arg string to IFZERO */    
        lexer_pushstr (truelist);
    else if (sscanf (symbol, "%d", &nr) > 0) /* can convert to a number */    
    {    
        if (nr)    
            lexer_pushstr (falselist);
        else    
            lexer_pushstr (truelist);
    }    
    else if ( (slot =                       /* is symbol a counter? */    
	        strtab_find (countername,
                 ncountername, symbol)    
	      ) != -1
	    )
    {    
        if (counterval [slot])
            lexer_pushstr (falselist);
        else    
            lexer_pushstr (truelist);
    }    
    else                                    /* all other cases */    
        lexer_pushstr (falselist);
        
    lexer ();                               /* prepare next symbol */

    free (symbol);                          /* return used memory */
    free (truelist);
    free (falselist);
}
