
/* Program configuration for yodl */
/* ------------------------------ */

/*
 * The macro INCLUDEFILE(file) will search for `file' as-is, or in a 
 * system-wide library directory. What's your default system-wide directory
 * for include files? This symbol should be set by the top-level Makefile.
 * Edit that file (in this directory) before changing it here.
 */
#ifndef STD_INCLUDE
#    define STD_INCLUDE     "/usr/local/lib/yodl"
#endif

/* 
 * The yodl program parses its input to a temporary output file, then re-parses
 * the output file to yet another file, and so on -- until no changes are
 * performed while parsing. That's how yodl expands macros that are in include
 * files, or defined in expansions, etc..
 * The following name defines how the files are named. Use two %d strings
 * in the names, one for the process id (to make sure that the files are 
 * unique) and one for the pass number. 
 * (NOTE: This parsing and re-parsing may already be altered when you read 
 * this info. Nevertheless, leave the TEMP_FILE setting in place.)
 */
#define TEMP_FILE           "/tmp/yodl%d.%d"

/* 
 * The approach of parsing and re-parsing can lead to endless loops, e.g., if
 * one macro leads to the expansion of another one, and the other one leads
 * to the first. Yodl will abort when more parsing passes are made than some
 * number, what's the default number of passes? Also set via the -p flag.
 */
#define DEFAULT_MAXPASS     20

/* 
 * For the "INCLUDEFILE(filename)" macro and for filenames on the command
 * line, yodl will supply a default extension (if needed). What's your
 * favorite default extension for the files?
 */
#define DEFAULT_EXT         ".yo"

