#!/bin/bash
#----------------------------------------------------------------------
# Generate OpenLDAP+Samba Domain Controler system
# for openSUSE 11.2 
#
# original is hotta at net-newbie.com
#
# if you have any question, please contact samba-jp at samba.gr.jp
#----------------------------------------------------------------------
#
# Please custmize following parameters
#----------- begin -------------------------
LDAP_TOP_DN='local'
LDAP_SECOND_DN='samba'
LDAP_CONFIG_PASSWORD=samba
LDAP_ADMIN_PASSWORD=samba
ADMINISTRATOR_USER=Administrator
ADMINISTRATOR_PASSWORD=samba
UNPRIVILEGED_USER=ldap01
UNPRIVILEGED_PASSWORD=ldap01
WORKGROUP_NAME=SAMBADOM
MYCOMUTER_NAME=`hostname -s 2>/dev/null`
if ($MYCOMPUTER_NAME) then
   MYCOMPUTER_NAME=`hostname`
fi
#----------- end -------------------------
LDAP_BASE_DN="dc=$LDAP_SECOND_DN,dc=$LDAP_TOP_DN"
LDAP_CONFIG_DN='cn=config'
LDAP_ADMIN_DN="cn=admin,$LDAP_BASE_DN"
SAMBA_VERSION=3.4.3
#KEEP_ORIGINAL_SAMBA=no
SKIP_INSTALL=no
# display and execute command
run() {
    echo "# $@"; 
    ${1+"$@"};
}

echo ------------------------------------------------------
echo stop daemons , unset pam-ldap , delete samba work file
echo ------------------------------------------------------
service winbind stop    >& /dev/null
service smb stop        >& /dev/null
service nmb stop        >& /dev/null
service ldap stop       >& /dev/null
yast ldap pam disable
find /var/log/samba/ -type f -exec rm {} \;
rm -rf /var/lib/samba/*

echo -----------------------------------------------
echo 'add HOSTNAME to /etc/hosts file'
echo -----------------------------------------------
cat >//tmp/awk.$$  <<'EOF'
# original rsyslog.conf
/127.0.0.1/ {
    if ( $3 !~ "sambapdc") {
        print "127.0.0.1	localhost sambapdc sambapdc.local" 
    }else {
	print
    }
    next
}
    { print }
EOF
awk -f /tmp/awk.$$ /etc/hosts >/tmp/hosts.$$
cp /tmp/hosts.$$ /etc/hosts
rm /tmp/awk.$$
rm /tmp/hosts.$$
echo -----------------------------------------------
echo 'modify /etc/rsyslog.conf file'
echo -----------------------------------------------
#edit only lines that have local4

cat >//tmp/awk.$$  <<'EOF'
# original rsyslog.conf
/local4,local5,*/ {
     print "local4.*                                -/var/log/ldap;RSYSLOG_TraditionalFileFormat"
     print "local5.*                                -/var/log/localmessages;RSYSLOG_TraditionalFileFormat"
     next
}
#local4 only line
/local4.*/ {
    if ( $2 ~ /\/var\/log\/localmessages/) {
        sub(/localmessages/,"ldap",$0)
        print $0
    } else {
        print $0
    }
    next
}
    { print }
EOF
awk -f /tmp/awk.$$ /etc/rsyslog.conf >/tmp/rsyslog.$$
cp /tmp/rsyslog.$$ /etc/rsyslog.conf
rm /tmp/awk.$$
rm /tmp/rsyslog.$$
service syslog restart
echo --------------------------------------------------------
echo make home directory base /home/$WORKGROUP_NAME and so on
echo -------------------------------------------------------
if [ ! -d /home/$WORKGROUP_NAME ]
then
   mkdir /home/$WORKGROUP_NAME
   chmod 1777 /home/$WORKGROUP_NAME
fi
if [ ! -d /home/group ]
then
   mkdir /home/group
   chmod 1777 /home/group
fi
if [ ! -d /home/recycletest ]
then
   mkdir /home/recycletest
   chmod 1777 /home/recycletest
fi
echo -----------------------------------------------
echo create dummy /etc/printcap
echo -----------------------------------------------
touch /etc/printcap

echo -----------------------------------------------
echo change /etc/ldap.conf,/etc/openldap/ldap.conf
echo -----------------------------------------------
yast ldap configure server=localhost base=$LDAP_BASE_DN verbose

echo -----------------------------------------------
echo 'copy LDAP schema file'
echo -----------------------------------------------
cp -p samba3.schema.org      /etc/openldap/schema/samba3.schema
cp -p slapd.conf.org         /etc/openldap/slapd.conf

echo -----------------------------------------------
echo copy Samba configuration file
echo -----------------------------------------------
cp -p smb.conf.org /etc/samba/smb.conf

echo -----------------------------------------------
echo add LDAP initial data
echo -----------------------------------------------
rm -f /var/lib/ldap/*
install -o ldap -g ldap DB_CONFIG.org /var/lib/ldap/DB_CONFIG
#cp -p DB_CONFIG.org /var/lib/ldap/DB_CONFIG
slapadd -l slapcat.ldif.org
chown -R ldap.ldap /var/lib/ldap
service ldap start

echo -----------------------------------------------
echo save LDAP administrator password
echo -----------------------------------------------
rm -f /etc/samba/secrets.tdb
( echo $LDAP_ADMIN_PASSWORD; echo $LDAP_ADMIN_PASSWORD ) | run smbpasswd -W -s
net idmap secret alloc $LDAP_ADMIN_PASSWORD

rm -f /var/cache/samba/winbind.pid
service winbind start
net getlocalsid
if ( ! service winbind status )
then
    echo winbind failed.
    exit 2
fi
net -d 1 -s /etc/samba/smb.conf sam provision

echo ------------------------------------------------------
echo start LDAP authentification and winbind
echo ------------------------------------------------------
yast ldap pam enable
yast ldap pam enable mkhomedir=yes
yast ldap pam enable tls=no
echo ------------------------------------------------------
echo set "$ADMINISTRATOR_USER 's SMB password and privileges"
echo ------------------------------------------------------
echo -e $ADMINISTRATOR_PASSWORD\\n$ADMINISTRATOR_PASSWORD | smbpasswd -s $ADMINISTRATOR_USER
net sam rights grant $ADMINISTRATOR_USER SeMachineAccountPrivilege
net sam rights grant $ADMINISTRATOR_USER SeTakeOwnershipPrivilege
net sam rights grant $ADMINISTRATOR_USER SeBackupPrivilege
net sam rights grant $ADMINISTRATOR_USER SeRestorePrivilege
net sam rights grant $ADMINISTRATOR_USER SeRemoteShutdownPrivilege
net sam rights grant $ADMINISTRATOR_USER SePrintOperatorPrivilege
net sam rights grant $ADMINISTRATOR_USER SeAddUsersPrivilege
net sam rights grant $ADMINISTRATOR_USER SeDiskOperatorPrivilege

echo ------------------------------------------
echo Samba service start
echo ------------------------------------------
service smb start
service nmb start
echo "wait Domain  $WORKGROUP_NAME is available"
CMD="net rpc info -U $ADMINISTRATOR_USER%$ADMINISTRATOR_PASSWORD"
echo "# $CMD"
OK=1
for i in `seq 1 10`
do
    if $CMD 2> /dev/null
    then
        echo "Domain $WORKGROUP_NAME is available"
        OK=0
        break
    else
        echo $i times
        sleep 1
    fi
done
if [ ! $OK ]
then
    echo "Domain $WORKGROUP_NAME is not available!!!"
    exit 3
fi
echo ------------------------------------------------------------------
echo create user for testing
echo User ID: $UNPRIVILEGED_USER  Password: $UNPRIVILEGED_PASSWORD   Username: 'LDAP User 01'
echo Home directory: \\\\$MYCOMUTER_NAME\\$UNPRIVILEGED_USER  Mount drive: H:
echo Password limit: no limit
echo ------------------------------------------------------------------
echo -e $UNPRIVILEGED_PASSWORD\\n$UNPRIVILEGED_PASSWORD | run pdbedit -a -t -u $UNPRIVILEGED_USER -t -D H: -h \\\\$MYCOMUTER_NAME\\$UNPRIVILEGED_USER -f 'LDAP User 01'
echo ------------------------------------------------------------------
echo test
echo ------------------------------------------------------------------
run net rpc user -U $UNPRIVILEGED_USER%$UNPRIVILEGED_PASSWORD
run net rpc group -U $UNPRIVILEGED_USER%$UNPRIVILEGED_PASSWORD
run id $ADMINISTRATOR_USER
run getent passwd $ADMINISTRATOR_USER
run id ldap01
run getent passwd $UNPRIVILEGED_USER
DN_COUNT=`ldapsearch -x -LLL '(objectclass=*)' dn | grep -v ^$ | wc -l`
if [ "$DN_COUNT" -lt 12 ]
then
    echo LDAP is not register correctly!!
fi


