/*
   Unix SMB/Netbios implementation.
   Version 2.0
   SMB wrapper functions - definitions
   Copyright (C) Andrew Tridgell 1998

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

#ifndef _SMBW_XSTAT_H
#define _SMBW_XSTAT_H

#ifdef HAVE_LONG_LONG
#define LLONG long long
#else
#define LLONG long
#endif

#ifdef HAVE___XSTAT
/* Definition of `struct stat', inclusive of that used in the linux kernels. */
struct smbw_xstat {
	unsigned int xst_dev;
	unsigned int xst_ino;
	unsigned int xst_mode;
	unsigned int xst_nlink;
	unsigned int xst_uid;
	unsigned int xst_gid;
	unsigned int xst_rdev;
	LLONG xst_size;
	LLONG xst_blksize;
	int xst_blocks;
	unsigned long int xst_atime;
	unsigned long int xst_mtime;
	unsigned long int xst_ctime;
};
#endif
#endif
