/* 
   Copyright (C) Andrew Tridgell 1996
   Copyright (C) Paul Mackerras 1996
   
   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2 of the License, or
   (at your option) any later version.
   
   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.
   
   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/

/* compatability routines for older rsync protocol versions */

#include "rsync.h"

extern int am_server;

extern int csum_length;

extern int preserve_links;
extern int preserve_perms;
extern int preserve_devices;
extern int preserve_uid;
extern int preserve_gid;
extern int preserve_times;
extern int always_checksum;
extern int checksum_seed;


extern int remote_version;
extern int verbose;

void setup_protocol(int f_out,int f_in)
{
  if (am_server) {
    remote_version = read_int(f_in);
    write_int(f_out,PROTOCOL_VERSION);
    write_flush(f_out);
  } else {
    write_int(f_out,PROTOCOL_VERSION);
    write_flush(f_out);
    remote_version = read_int(f_in);
  }

  if (remote_version < MIN_PROTOCOL_VERSION ||
      remote_version > MAX_PROTOCOL_VERSION) {
    fprintf(FERROR,"protocol version mismatch - is your shell clean?\n");
    exit_cleanup(1);
  }	

  if (verbose > 2)
	  fprintf(FINFO, "local_version=%d remote_version=%d\n",
		  PROTOCOL_VERSION, remote_version);

  if (remote_version >= 12) {
    if (am_server) {
      checksum_seed = time(NULL);
      write_int(f_out,checksum_seed);
    } else {
      checksum_seed = read_int(f_in);
    }
  }

  checksum_init();
}

