#!/usr/local/bin/perl
#
# This is a hacked version of files.pl for systems that can't do a 'make files'.
# Do a perl util/mkminfo.pl >MINFO to build MINFO
# Written by Steve Henson 1999.

# List of directories to process

my @dirs = (
".",
"crypto",
"crypto/md2",
"crypto/md4",
"crypto/md5",
"crypto/sha",
"crypto/mdc2",
"crypto/hmac",
"crypto/ripemd",
"crypto/des",
"crypto/rc2",
"crypto/rc4",
"crypto/rc5",
"crypto/idea",
"crypto/bf",
"crypto/cast",
"crypto/aes",
"crypto/camellia",
"crypto/seed",
"crypto/modes",
"crypto/cmac",
"crypto/bn",
"crypto/rsa",
"crypto/dsa",
"crypto/dso",
"crypto/dh",
"crypto/ec",
"crypto/buffer",
"crypto/bio",
"crypto/stack",
"crypto/lhash",
"crypto/rand",
"crypto/err",
"crypto/objects",
"crypto/evp",
"crypto/asn1",
"crypto/pem",
"crypto/x509",
"crypto/x509v3",
"crypto/cms",
"crypto/conf",
"crypto/jpake",
"crypto/txt_db",
"crypto/pkcs7",
"crypto/pkcs12",
"crypto/comp",
"crypto/engine",
"crypto/ocsp",
"crypto/ui",
#"crypto/store",
"crypto/whrlpool",
"crypto/ts",
"crypto/srp",
"crypto/ct",
"crypto/async",
"crypto/chacha",
"crypto/poly1305",
"crypto/kdf",
"ssl",
"apps",
"engines",
"test",
"tools"
);

%top;

my $fipscanisteronly = 0;

foreach (@dirs) {
	next if ($fipscanisteronly && !(-d $_));
	&files_dir ($_, "Makefile");
}

exit(0);

sub files_dir
{
my ($dir, $makefile) = @_;

my %sym;

open (IN, "$dir/$makefile") || die "Can't open $dir/$makefile";

my $s="";

while (<IN>)
	{
	s|\R$||;
	s/#.*//;
	if (/^([^\s=]+)\s*=\s*(.*)$/)
		{
		$o="";
		($s,$b)=($1,$2);
		for (;;)
			{
			if ($b =~ /\\$/)
				{
				$b=$`;
				$o.=$b." ";
				$b = "" unless defined($b = <IN>);
				$b =~ s{\R$}{};
				}
			else
				{
				$o.=$b." ";
				last;
				}
			}
		$o =~ s/^\s+//;
		$o =~ s/\s+$//;
		$o =~ s/\s+/ /g;

		$o =~ s/\$[({]([^)}]+)[)}]/$top{$1} or $sym{$1}/ge;
		$sym{$s}=($top{$s} or $o);
		}
	}

print "RELATIVE_DIRECTORY=$dir\n";

foreach (sort keys %sym)
	{
	print "$_=$sym{$_}\n";
	}
if ($dir eq "." && defined($sym{"BUILDENV"}))
	{
	foreach (split(' ',$sym{"BUILDENV"}))
		{
		/^(.+)=/;
		$top{$1}=$sym{$1};
		}
	}

print "RELATIVE_DIRECTORY=\n";

close (IN);
if ($dir eq "." && $sym{FIPSCANISTERONLY} eq "y")
	{
	$fipscanisteronly = 1;
	}
}
