# Log_to_date
# Log_to_date.pl 1.2 1995/09/29 18:44:21 davidsen Exp
#
#   Convert w netnews log file date in Mon DD format to
#   a YYMMDD format
#

# Convert INN log dates in "MMM DD" format yo "YYMMDD"
#   (assumes this is done within a few months of log time)
#
sub Log_to_date
{
  local (@mon, $nmon);
  local ($sec, $min, $hr, $day, $moy, $yr, $dow, $doy, $dst);
  local ($Tmon, $Tday);

  ($Tmon, $Tday) = @_;
  @mon = ("Jan","Feb","Mar","Apr","May","Jun",
    "Jul","Aug","Sep","Oct","Nov","Dec");
  #
  # find the numeric month (1 based)
  for ($nmon = 0; $nmon < 12; ++$nmon) { last if $Tmon eq @mon[$nmon]; }
  ++$nmon;
  #
  # Test for end of year rollover, log data in Dec, analysis next year
  ($sec, $min, $hr, $day, $moy, $yr, $dow, $doy, $dst) = (localtime);
  if ( $nmon == 12 && $mon < 12 ) { --$yr; }
  #
  # generate and return a numeric date string
  return sprintf("%02d%02d%02d", $yr, $nmon, $Tday);
}
TRUE;
