#! /bin/sh
##  $Revision: 1.14 $
##  Script to make INN directories.

##  Some systems don't support -x, so we have to use -f.
CHOWN=chown
if [ ${CHOWN} = chown ] ; then
    if [ -f /sbin/chown ] ; then
	CHOWN=/sbin/chown
    else
	if [ -f /etc/chown ] ; then
	    CHOWN=/etc/chown
	else
	    if [ -f /usr/etc/chown ] ; then
		CHOWN=/usr/etc/chown
	    fi
	fi
    fi
fi

##  =()<MAN1=@<MAN1>@>()=
MAN1=/news/lib/inn/man/man1
##  =()<MAN3=@<MAN3>@>()=
MAN3=/news/lib/inn/man/man3
##  =()<MAN5=@<MAN5>@>()=
MAN5=/news/lib/inn/man/man5
##  =()<MAN8=@<MAN8>@>()=
MAN8=/news/lib/inn/man/man8
MAN=`echo $MAN8 | sed -e 's@\(.*\)/[^/]*@\1@'`

##  =()<SPOOL=@<_PATH_SPOOL>@>()=
SPOOL=/news/spool/news
## =()<OVERVIEWDIR=@<_PATH_OVERVIEWDIR>@>()=
OVERVIEWDIR=/news/spool/overview
##  =()<ARCHIVEDIR=@<_PATH_ARCHIVEDIR>@>()=
ARCHIVEDIR=/news/spool/archive
##  =()<BATCHDIR=@<_PATH_BATCHDIR>@>()=
BATCHDIR=/news/spool/batch
##  =()<MOST_LOGS=@<_PATH_MOST_LOGS>@>()=
MOST_LOGS=/news/spool/log
## =()<PATH_AUTHDIR=@<_PATH_AUTHDIR>@>()=
PATH_AUTHDIR=/news/lib/inn/bin/auth
##  =()<SPOOLNEWS=@<_PATH_SPOOLNEWS>@>()=
SPOOLNEWS=/news/spool/in.coming
##  =()<BADNEWS=@<_PATH_BADNEWS>@>()=
BADNEWS=/news/spool/in.coming/bad
##  =()<SPOOLTEMP=@<_PATH_SPOOLTEMP>@>()=
SPOOLTEMP=/news/spool/in.coming

##  =()<NEWSLIB=@<_PATH_NEWSLIB>@>()=
NEWSLIB=/news/lib/inn/lib
##  =()<NEWSBIN=@<_PATH_NEWSBIN>@>()=
NEWSBIN=/news/lib/inn/bin
##  =()<CONTROLPROGS=@<_PATH_CONTROLPROGS>@>()=
CONTROLPROGS=/news/lib/inn/libexec/control
##  =()<RNEWSPROGS=@<_PATH_RNEWSPROGS>@>()=
RNEWSPROGS=/news/lib/inn/libexec/rnews
##  =()<INNDDIR=@<_PATH_INNDDIR>@>()=
INNDDIR=/news/lib/inn/lib/sockets
##  =()<LOCKSDIR=@<_PATH_LOCKS>@>()=
LOCKSDIR=/news/spool/batch
## =()<MOST_LOGS=@<_PATH_MOST_LOGS>@>()=
MOST_LOGS=/news/spool/log
## =()<LOCKS=@<_PATH_LOCKS>@>()=
LOCKS=/news/spool/batch

##  =()<NEWSETC=@<_PATH_NEWSBOOT>@>()=
NEWSETC=/news/lib/inn/etc/rc.news
NEWSETC="`dirname ${NEWSETC}`"
##  =()<NEWSHIST=@<_PATH_HISTORY>@>()=
NEWSHIST=/news/lib/inn/var/history
NEWSHIST="`dirname ${NEWSHIST}`"
##  =()<NEWSTMP=@<_PATH_TMP>@>()=
NEWSTMP=/tmp
##  =()<NEWSHOME=@<_PATH_NEWSHOME>@>()=
NEWSHOME=/home/user/news
NEWSLBIN=${NEWSHOME}/local

##  =()<NEWSUSER=@<NEWSUSER>@>()=
NEWSUSER=news
##  =()<NEWSGROUP=@<NEWSGROUP>@>()=
NEWSGROUP=news

PFLAG="$1"
umask 0
set -x

for F in \
${MAN} ${MAN1} ${MAN3} ${MAN5} ${MAN8} \
${NEWSHOME} ${NEWSETC} ${NEWSHIST} ${NEWSTMP} ${NEWSLBIN} \
${SPOOL} ${OVERVIEWDIR} ${ARCHIVEDIR} ${BATCHDIR} ${LOCKS} \
${MOST_LOGS} ${MOST_LOGS}/OLD \
${SPOOLNEWS} ${BADNEWS} ${SPOOLTEMP} \
${NEWSLIB} ${INNDDIR} ${LOCKSDIR} \
${NEWSBIN} ${CONTROLPROGS} ${RNEWSPROGS} \
${PATH_AUTHDIR} ; do

    if [ ! -d ${F} ] ; then
	mkdir ${PFLAG} ${DESTDIR}${F} || exit 1
	${CHOWN} ${NEWSUSER} ${DESTDIR}${F} || exit 1
	chgrp ${NEWSGROUP} ${DESTDIR}${F} || exit 1
	case ${F} in
	${INNDDIR})
	    chmod 0770 ${DESTDIR}${F} || exit 1
	    ;;
	*)
	    chmod 0775 ${DESTDIR}${F} || exit 1
	    ;;
	esac
    fi

done

exit 0
