#!/usr/bin/perl

# This script will get information from the Netgear RT311's web interface to feed into MRTG
# Written by Spencer Thomas
# Email me at evoluder@bellsouth or visit my homepage at http://partypics.kicks-ass.net if you have
# any questions / contributions / fixes etc.
# This script has been tested under Redhat 7.2 with Lynx 2.8rel1 and the 3.25 RT311 ROM with no problems

# Warning! Connecting to the web interface while using this script will most likely cause
# it to fail as the router only allows one connection at a time (per IP?)

# Change the path to the perl interpreter above if yours is different

my @statpage, $line, $wanname, $wantxpk, $wanrxpk, $wantx, $wanrx, $wanuptime, $lanname, $lantxpk, $lanrxpk, $lantx, $lanrx, $lanuptime, $count, $username, $password, $routerip, $lynx;

# Change these to match your settings, the default on RT311 routers is username=admin, password=admin, routerip=192.168.0.1
# You could use the WAN IP/hostname to get this information from the WAN side of the router (if enabled)

$username = "";
$password = "";
$routerip = "";

# Change this to the path to your Lynx executable

$lynx = "/usr/bin/lynx";

# ---------------- Don't modify anything below here unless you know what you are doing!

# Display usage if no options given

if ($ARGV[0] eq '' || $ARGV[1] eq '') {
   print "\nUsage: rt311.pl [interface] [output]\n";
   print "\n   interface - lan or wan";
   print "\n   output - packets or bytes";
   print "\n\n   example: rt311.pl lan packets\n\n";
   exit;
}

# Get stats page w/ lynx

@statpage = `$lynx -dump -auth=$username:$password http://$routerip/mtenSysStatistics.html`;

$count = 0;

foreach $line (@statpage) {

   $count = $count + 1;

   # Strip out the whitespaces

   $line =~ s/^\s+//;
   $line =~ s/\s+$//;

      # Parse out all the info

      if ($count == 20) {
         $wanname = $line;
      } elsif ($count == 22) {
         $wantxpk = $line;
      } elsif ($count == 24) {
         $wanrxpk = $line;
      } elsif ($count == 28) {
         $wantx = $line;
      } elsif ($count == 30) {
         $wanrx = $line;
      } elsif ($count == 32) {
         $wanuptime = $line;
      } elsif ($count == 36) {
         $lanname = $line;
      } elsif ($count == 38) {
         $lantxpk = $line;
      } elsif ($count == 40) {
         $lanrxpk = $line;
      } elsif ($count == 44) {
         $lantx = $line;
      } elsif ($count == 46) {
         $lanrx = $line;
      } elsif ($count == 48) {
         $lanuptime = $line;
      }

}

# Display various information in "MRTG format" based on the arguments provided

if ($ARGV[0] eq 'lan') {

   if ($ARGV[1] eq 'packets') {
      print "$lantxpk\n$lanrxpk";
   } elsif ($ARGV[1] eq 'bytes') {
      print "$lantx\n$lanrx";
   } else {
      print "\nI don't understand the argument \"$ARGV[1]\"\n\n";
      exit;
   }

   print "\n$lanuptime\n$lanname\n";

} elsif ($ARGV[0] eq 'wan') {

   if ($ARGV[1] eq 'packets') {
      print "$wantxpk\n$wanrxpk";
   } elsif ($ARGV[1] eq 'bytes') {
      print "$wantx\n$wanrx";
   } else {
      print "\nI don't understand the argument \"$ARGV[1]\"\n\n";
      exit;
   }

   print "\n$wanuptime\n$wanname\n";

} else {

   print "\nI don't understand the argument \"$ARGV[0]\"\n\n";
   exit;

}

