#!c:\perl\bin\perl -w
#
# roamabout.pl
#
#	Generates signal and noise level on a Roamabout station for MRTG.
#
#	Parameters:
#		Roamabout IP address: 10.10.10.10
#		SNMP R/W community string: string
#		Remote station MAC address: FF-FF-FF-FF-FF-FF
#		Sampling interval: 1-1000
#
#	Output: (MRTG data format)
#		Line 1: Roamabout local noise level 
#		Line 2: Roamabout local signal level 
#		Line 3: string (in any human readable format), telling the uptime of the target. 
#		Line 4: string, telling the name of the target. 
#
#	Comments:
#		SNMP community string needs to be R/W in order to set the remote station MAC address.
#		The use of R/W SNMP community strings could be a security thread in some environments.
#	
#	v1.0	2002/2/11	Jorge Lodos Vigil (jorge.lodos@cigb.edu.cu)
#
use strict;

#SNMP Perl
#SNMP_util path goes here if not already in @INC
use lib 'c:\mrtg\lib\mrtg2';
use SNMP_util;

# Constants
my $roamabout_station_ip  = $ARGV[0] || die "usage: $0 <Roamabout IP address> <Remote station MAC address> <SNMP R/W community string> [sampling interval]";
my $remote_station_mac    = $ARGV[1] || die "usage: $0 <Roamabout IP address> <Remote station MAC address> <SNMP R/W community string> [sampling interval]";
my $snmp_community_string = $ARGV[2] || die "usage: $0 <Roamabout IP address> <Remote station MAC address> <SNMP R/W community string> [sampling interval]";
my $sampling_interval     = $ARGV[3] || 1;
my $host= $snmp_community_string."@".$roamabout_station_ip;

# Convert MAC address to the expected Roamabout format
my @mac_address_fields = split(/-/, $remote_station_mac);
foreach my $field (@mac_address_fields) {
	$field = chr(hex($field));
}
$remote_station_mac = join("", @mac_address_fields);

# Set the MAC address of a remote Roamabout station
snmpset ($host, '1.3.6.1.4.1.36.2.18.35.14.1.0', 'string', $remote_station_mac);

# Set station sampling interval
# Writing a 1 causes a single test to be performed
snmpset ($host, '1.3.6.1.4.1.36.2.18.35.14.6.0', 'int', $sampling_interval);

# Get noise level
my @noise_level = snmpget ($host, '1.3.6.1.4.1.36.2.18.35.14.8.0');
$noise_level[0] -= 149;	# if using RRDTOOL only! Otherwise comment this line.

# Get signal level
my @signal_level = snmpget ($host, '1.3.6.1.4.1.36.2.18.35.14.7.0');
$signal_level[0] -= 149; # if using RRDTOOL only! Otherwise comment this line.

#Get system uptime
my @system_uptime = snmpget ($host, '1.3.6.1.2.1.1.3.0');

# Print results in MRTG format
print "@noise_level\n";
print "@signal_level\n";
print "@system_uptime\n";
print "$roamabout_station_ip\n";
exit(0);

