/* Creation of a PNG Image from a reference PNG Image replacing many colors
   by other colors depending on the traffic rate on interfaces.
   L. Derrien 19/8/99
   Update LD  17/10/00 : Process many netmaps hierarchicaly.
*/ 

#include <stdio.h>
#include <gd.h>
#include <string.h>

/* WATCOM C/C++ 10.6 under Win95/NT */
/* VC++ 6.0 under Win95/NT */
#if defined(__WATCOMC__) || defined(WIN32)
#include <sys\types.h>
#include <direct.h>
#include <io.h>
#endif

#include "cfg.h"

/* computes a traffic in % by reading 'rounds' lines in a MRTG log file */
/* For mixed I/O traffic, it takes the maximum of the In or OUT traffic.*/
/* It returns this maximum rate. */
int comp_log (netmap *NMap, cfgentry *ce) {

  FILE    *logf;
  int     i, j=0, k=0, rateIn=0, rateOut=0, rate=0, In, Out, IO;
  char fic[100];

  sprintf(fic, "%s/%s.log", NMap->WDir, ce->ifname);
  if ((logf = fopen ( fic, "r" ))==NULL) {
         fprintf(stderr, "Error opening the log file %s\n", fic);
         return(0);
  }

  fscanf(logf, "%*d %d %d", &j, &k);                              
  /* get first line */

  In  = (ce->ColorIdxIn>=0  && ce->ColorIdxIn<256  && ce->MaxRateIn>0);
  Out = (ce->ColorIdxOut>=0 && ce->ColorIdxOut<256 && ce->MaxRateOut>0);
  IO  = (ce->ColorIdx>=0    && ce->ColorIdx<256    && ce->MaxRate>0);

  for ( i = 0; i < ce->rounds; i++ ) {                               
        /* computes mean */
          fscanf(logf, "%*d %d %d %*d %*d", &j, &k);                        
			/* get line */
                        /* printf(" - [%d %d]\n", j, k); */
          if (In)     rateIn  += j;
          if (Out)    rateOut += k;
          /* Max (In, Out) */ 
          if ( j > k )    rate += j;
          else            rate += k;
  }               
                  
  fclose (logf);
                                                                
        /* computes the rate 0-9 */

  if (In) {      
  	if (ce->rounds>1) rateIn /= ce->rounds; 
  	rateIn  = (rateIn * NLEVEL) / ce->MaxRateIn;
  	if ( rateIn >= NLEVEL ) rateIn = NLEVEL-1;
  	if ( rateIn < 0 ) rateIn = 0;
  	NMap->level[ce->ColorIdxIn] = rateIn;
  	/* printf("Idx: %d  rate: %d\n", ce->ColorIdxIn, rateIn); */
  }  

  if (Out) {      
  	if (ce->rounds>1) rateOut /= ce->rounds; 
  	rateOut  = (rateOut * NLEVEL) / ce->MaxRateOut;
  	if ( rateOut >= NLEVEL ) rateOut = NLEVEL-1;
  	if ( rateOut < 0 ) rateOut = 0;
  	NMap->level[ce->ColorIdxOut] = rateOut;
  	/* printf("Idx: %d  rate: %d\n", ce->ColorIdxOut, rateOut); */
  }

  if (ce->rounds>1) rate /= ce->rounds; 
  rate  = (rate * NLEVEL) / ce->MaxRate;
  if ( rate >= NLEVEL ) rate = NLEVEL-1;
  if ( rate < 0 ) rate = 0;
  if (IO) NMap->level[ce->ColorIdx] = rate;
  /* printf("Idx: %d  rate: %d\n", ce->ColorIdx, rate); */
    
  return(rate);
}


/* Compute the rate levels for all the color indexes in the config file */
/* for the netmap NMap. It returns the max rate in this netmap. */
/* This function is recursive, so all submaps of NMap are also processed. */
int comp_levels(netmap *NMap)
{
  cfgentry *ptr;
  int i, tmpv, globrate=0;
  
  ptr = NMap->LCfgEntry;
  
  for (i=0; i<256; i++) NMap->level[i] = -1; /* Init */
  
  while (ptr) {
    if (ptr->submap) {
    	if (ptr->submap->globval == -1) { 
    	  if ((tmpv=comp_levels(ptr->submap))>globrate) globrate = tmpv;
    	}
	else { if ((tmpv=ptr->submap->globval)>globrate) globrate = tmpv; }   	
	NMap->level[ptr->ColorIdx] = tmpv;
    }
    else { if ((tmpv=comp_log(NMap, ptr))>globrate) globrate = tmpv; }
    ptr = ptr->nextcfg;
  }
  
  FreeLCfg(NMap); /* we don't need this LCfgEntry anymore */

  return (NMap->globval = globrate);
}

/* Create a new PNG image from the reference PNG image changing the color */
/* of the links depending on the rates... */
int comp_pic(netmap *NMap)
{
  char fic[100];
  gdImagePtr im;
  FILE *in, *out;
  int c, y, x;
  int TLC[256];
 
  for (c=0; c<256; c++) TLC[c] = -1; /* init */
   
  /* No image => no pocessing */
  if (!strlen(NMap->pngin)) return(0); 
  
  sprintf(fic, "%s/%s", NMap->WDir, NMap->pngin);
  if ((in = fopen(fic, "rb")) == NULL) {
         fprintf(stderr, "Error opening the image file %s\n", NMap->pngin);
         return(0);
  } 
  im = gdImageCreateFromPng(in);
  fclose(in);
  
  for (y=0; y<gdImageSX(im); y++)
    for (x=0; x<gdImageSX(im); x++) {
  	c = gdImageGetPixel(im, x, y);
  	if (NMap->level[c] >=0) {
  		if (NMap->level[c]>=NLEVEL) NMap->level[c]=NLEVEL-1;
  		if (TLC[c]==-1) TLC[c] = gdImageColorResolve(im, 
  			levcolor[NMap->level[c]].r,
  			levcolor[NMap->level[c]].g , 
  			levcolor[NMap->level[c]].b);
  		gdImageSetPixel(im, x, y, TLC[c]);
	}
    }		
  	
  /* Open output file in binary mode */
  sprintf(fic, "%s/%s", NMap->WDir, NMap->pngout);
  if ((out = fopen(fic, "wb")) == NULL) {
        fprintf(stderr, "Error opening the image file %s\n", NMap->pngout);
        return(0);
  }
  
  gdImageInterlace(im, 1);
  /* Write PNG */
  gdImagePng(im, out);
  /* Close file */
  fclose(out);
  
  gdImageDestroy(im);

  return(1);
}

/* comp_levels deals with a branch of one tree of netmaps. */
/* Here, we process all the trees. */
/* Besides, when a netmap is prepared, we process its image. */
void comp_netmaps() {
  netmap *ptr = LMap;
  
  while (ptr) { 
    if (ptr->globval == -1) comp_levels(ptr);
    comp_pic(ptr);
    ptr = ptr->nextmap;
  }
}  
