#! /usr/bin/perl
# -*- mode: Perl -*-

#
# PATCH TO APPLY TO MRTG FOR PICNET
#
# INSTALLATION :
# 1- Copy picnet (or picnet.exe) and patch.pm in the same directory as mrtg.
# 2- cp mrtg mrtg.bak
# 3- perl patch.pm mrtg.bak > mrtg
# 4- Now, you can use the following syntax in the call to mrtg :
#    <mrtg-bin>/mrtg <mrtg-cfg>/mrtg.cfg <picnet-cfg>/picnet.cfg
#    and PicNet will run when mrtg updates the data.
#

while (<>) {
   if (!$ishere && / #In daemon mode run forever/)
   { # Insert the patch for PicNet at the end of the main loop...
     print "\n# PICNET PATCH...\n\n";
     print "\tmy \$cfgpicnet = shift \@ARGV;\n";
     print "\tmy \@picnetexec;\n";
     print "\t(\$cfgpicnet=\$cfgfile) unless defined \$cfgpicnet;\n";
     print "\t\@picnetexec = (\"\$\{FindBin::Bin\}\$\{MRTG_lib::SL\}";
     print "picnet\",\"\$cfgpicnet\");\n";
     print "\tif (\$MRTG_lib::OS eq 'VMS' || \$MRTG_lib::OS eq 'NT') \{\n";
     print "\t  open (PICNET, join (\" \", \@picnetexec).\"|\");\n";
     print "\t\} else \{\n";
     print "\t  open (PICNET, \"-|\") || exec \@picnetexec;\n";
     print "\t} close (PICNET);\n";
     print "\n# END OF PICNET PATCH \n\n";
   }
   if ($. == 6 && !($ishere = /^# \* PICNET PATCH INSTALLED \*/)) {
	     print "# * PICNET PATCH INSTALLED *\n";
   }
   print "$_";
}
