package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.awt.event.*;

/**Dialog with 2 Buttons: Yes or No.
 *
 * @author 	David Flanagan, O'Reilly & Assoc.
 * @author 	Michael Grob for RA/SL (minor changes)
 * @version 	1.01 09/04/98
 */
public class YesNoDialog extends Dialog {
	public static final int NO =0;
	public static final int YES = 1;
	public static final int CANCEL = -1;
	
	public Button yes = null, no = null, cancel =null;
	public MultiLineLabel label;
	
	/**Constructor with all arguments.
	 *
	 * @param parent	A Frame
	 * @param title		String with window title
	 * @param message	String with the message
	 * @param yes_label	String with text of yes button
	 * @param no_label	String with text of no button
	 * @param cancel_label	STring with text of cancel button
	 */
	public YesNoDialog (Frame parent, String title, String message, String yes_label, String no_label, String cancel_label) {
		super(parent, title, true);
		this.setLayout(new BorderLayout(15, 15));
		label = new MultiLineLabel(message, 20, 20);
		this.add("Center", label);
		this.setBackground(Color.lightGray);

		
		Panel p = new Panel();
		p.setLayout(new FlowLayout(FlowLayout.CENTER, 15, 15));
		if(yes_label != null) p.add(yes=new Button(yes_label));
		if(no_label != null) p.add(no=new Button(no_label));
		if(cancel_label != null) p.add(cancel=new Button(cancel_label));

		this.add("South", p);
		
		this.pack();
		
	}
	public void kill() {
		this.setVisible(false);
		this.dispose();
	}

}
