package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.net.*;
import java.io.*;


/** Implements an output channel as an interface between applet and cgi script.
 * It sends line by line to the cgi.
 * It uses a URLConnection for the communication, which means that the data is transfered as 
 * plain text from the web server. This class parses it, creates a Cfg object an fills the data in.
 * 
 * @author	Michael Grob for RA/SL
 * @version 	1.01, /09/04/98/
 */
public class OutputChannel {

	// some constants
	// NOT FINAL YET! This will be a PARAM in the applet
	// not declared as constant, so it can be overwritten by the Applet or whoever
	public String URL_OF_CGI;
	DataOutputStream printout;
	BufferedReader input;
	URLConnection urlConn;
	public boolean connectionIsOpen; // true if connection could be opened.

	/**Opens a connection to the cgi which feeds it into cfg file
	 *
	 * @param cmd	String to determine if it should be written or deleted
	 * @param url		url of the file
	 * @param backupUrl	url of the backup file
	 * @return		<code>true</code> if successful. <code>false</code>otherwise
	 */
	public OutputChannel(String cmd, String url, String backupUrl, String cgiURL) {
		this.super();

		// build the url
		URL_OF_CGI = cgiURL;
	
		// connection to server
		
		try {
			// call cgi
			URL UrlOfCgi = new URL(this.URL_OF_CGI);
			urlConn = UrlOfCgi.openConnection();
			urlConn.setUseCaches(false);
	
			// we want input!
			urlConn.setDoInput(true);

			// and output!
			urlConn.setDoOutput(true);

			// No caching, we want the real thing
			urlConn.setUseCaches(false);
		
			// Specify the content type
			urlConn.setRequestProperty("Content-Type", "application/x-www-form-urlencoded");
			
			// Send POST Output
			printout = new DataOutputStream (urlConn.getOutputStream());
			printout.writeBytes(cmd + "=" + url + " & ");
			printout.writeBytes("BACKUP=" + backupUrl + " & ");
			
			}
		catch (MalformedURLException me) {
			AWTHelper.warn("MalformedURLException:" + me);
		}
		catch (IOException ioe) {
			AWTHelper.warn("IOException:" + ioe);
		}
		connectionIsOpen = true;
	}


	/** Sends a line to the cgi script.
	 *
	 * @param line	String with line to send in it
	 * @return <code>true</code> if successful, <code>false</code>otherwise.
	 */

	public boolean sendLine(String line) {
		if (connectionIsOpen) {
			try {
				printout.writeBytes(line);
			}
			catch (MalformedURLException me) {
				AWTHelper.warn("MalformedURLException:" + me);
				return false;
			}
			catch (IOException ioe) {
				AWTHelper.warn("IOException:" + ioe);
				return false;
			}
			return true;
		}
		else {
			AWTHelper.warn("Connection is not open.");
			return false;
		}
	}


	/** Closes the connection and gives back the feedback from cgi.
	 *
	 * @return <code>true</code> if successful, <code>false</code> otherwise.
	 */
	public boolean closeConnection() {
		String nextline;
		try {
			// flush and close the output stream, so we can listen to the input
			printout.flush();
			printout.close();
			// open input stream and
			input = new BufferedReader( new InputStreamReader(urlConn.getInputStream()));

			// read line
			nextline = input.readLine();	
			input.close();
		}
		catch (MalformedURLException me) {
			AWTHelper.warn("MalformedURLException:" + me);
			connectionIsOpen = false;	
			return false;
		}
		catch (IOException ioe) {
			AWTHelper.warn("IOException:" + ioe);
			connectionIsOpen = false;
			return false;
		}
		System.out.println(nextline);
		if (nextline.equals("OK")) {
			connectionIsOpen = false;
			return true;
		}
		else if (nextline.equals("ERROR")) {
		}
		connectionIsOpen = false;
		return false;
	}
}
