package ch.swisslife.ibgm.mc2;
import java.awt.*;

/** Dialog for opening a device which will be used for checking the ports.
 * @author 	Michael Grob for RA/SL
 * @version 	1.01 09/04/98
 */
public class LineDialog extends ChooseDialog {

	/** constructor of LineDialog. Uses a textfield with the address of the device to be checked.
	 * @param title 	title of the dialog in a String
	 * @param explanation	String with the explanation
	 * @param host		String with the host address of the device to be checked. */
	
	public LineDialog(String title, String explanation, String host) {
		this.super(title);
		//this.explanation.setText(explanation);

		//instantiate the objects
		field = new TextField(40);
		this. field.setText(host);
		field.setBackground(Color.white);

		this.explanation = new Label(explanation);
		p.setLayout(gridbag);
		this.setLayout(new GridBagLayout());
		button1 = new Button("OK");
		button2 = new Button("Cancel");
		this.setBackground(Color.lightGray);


		// arrange the Items
		AWTHelper.constrain(p, this.explanation, 0,0,2,1, GridBagConstraints.HORIZONTAL, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(p, field, 0,1,2,1);
		AWTHelper.constrain(p, button1, 0,6,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,0,0,0);
		AWTHelper.constrain(p, button2, 1,6,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHEAST, 0.0,0.0,5,0,0,0);
		AWTHelper.constrain(this, p, 0,0,1,1, GridBagConstraints.NONE, GridBagConstraints.CENTER, 0.0,0.0,10,10,10,10);
	}

	public String getURL() {
		return field.getText();
	}

}
