package ch.swisslife.ibgm.mc2;
import java.awt.*;
import java.awt.event.*;
import java.util.*;

/** User Interface and tools for editing a target entry. Opens a window and displays
 * all entries per target. User can edit it them and write them back.
 * 
 * @author Michael Grob for RA/SL
 * @version 1.01 09/04/98
 */
 public class EditTarget extends Frame {

	// Data structure:

	int current = 0; 					// which target is active;
	Cfg file, temp;						// the data structure;
	EditTarget et;
	MC2 parent;						// parent class of this (class which initiates it) < ----- CHANGE FOR FINAL!	
	GridBagLayout gridbag = new GridBagLayout();		// Layout-Manager fuer alle container
	YesNoDialog close_dialog;				// Close dialog

	// labels

	Label title, explanation; 				//for the title and its explanation
	Label target_label, port_label, comm_label; 		// explanation of text fields
	Label address_label, oid1_label, oid2_label; 		// dito for Panel1
	Label date_label, creator_label, comment_label;		// for Panel2
	Label title_label, maxbytes_label, absmax_label; 	// for Panel3
	Label options_label, x_label, y_label;			// dito
	Label unscaled_label, with_peak_label, colours_label;	// dito
	Label page_label, maintainer_label, system_label; 	// for Panel4
	Label interface_label, ip_label, maxspeed_label; 	// dito
	Label ylegend_label, short_label, legend1_label;	// for Panel5
	Label legend2_label, legend3_label, legend4_label; 	// dito
	Label legendi_label, legendo_label		; 	// dito

	// text fields

	TextField  target_field, port_field, comm_field;		// Fields for Panel1
	TextField address_field, oid1_field, oid2_field; 	// dito for Panel1
	TextField date_field, creator_field;			// for Panel2
//	TextArea comment_area;					// because we want more than one line
	TextField comment_field, title_field, maxbytes_field, absmax_field; 	// for Panel3
	TextField options_field, x_field, y_field;		// dito
	TextField unscaled_field, with_peak_field, colours_field;	// dito
	TextField page_field, maintainer_field, system_field;	// for Panel4
	TextField interface_field, ip_field, maxspeed_field;	// dito
	TextField ylegend_field, short_field, legend1_field;	// for Panel5
	TextField legend2_field, legend3_field, legend4_field; 	// dito
	TextField legendi_field, legendo_field;		 	// dito

	Label status_field, info_label;
	MultiLineLabel info_field;

	// panels
	Panel panel1, panel2, panel3, panel4;				// panels
	Panel panel5, panel6, button_panel, status_panel;
	//Panel label_panel1, label_panel2, label_panel3, label_panel4;	// panels for the labels
	//Panel label_panel5, label_panel6;

	// buttons

	Button save, Left, Right, close, revert;	// NOT FINAL! Only for testing, 

	/** Constructor with a Cfg and an int as Argument. It brings upa window and copies all 
	 * the entries into the corresponding fields.
	 *
	 * @param file		CFG with actual entries
	 * @param current 	int with actual target
	 */
	public EditTarget(Cfg f, int c, MC2 p) {
		this.super("Edit Target");
		this.parent = p;
		et = this;
		this.file = f;
		try {
			this.temp= (Cfg) f.clone(); // explicit copy of f
		}
		catch (java.lang.CloneNotSupportedException e) {
			AWTHelper.warn("CloneNotSupportedException: " + e);
		}
		this.current = c;

		// setting up all the labels
		target_label = new Label("Target:");
		port_label = new Label("Port:");
		comm_label = new Label("Community:");
		address_label = new Label("Address:");
		oid1_label = new Label("OID 1:");
		oid2_label = new Label("OID 2:");
		date_label = new Label("Date:");
		creator_label = new Label("Creator:");
		comment_label = new Label("Comment:");
		title_label = new Label("Title:");
		maxbytes_label = new Label("MaxBytes:");
		absmax_label = new Label("AbsMax:");
		options_label = new Label("Options:");
		x_label = new Label("XSize:");
		y_label = new Label("YSize:");
		unscaled_label = new Label("Unscaled:");
		with_peak_label = new Label("WithPeak:");
		colours_label = new Label("Colours:");
		page_label = new Label("PageTop Title:");
		maintainer_label = new Label("Maintainer:");
		system_label = new Label("System:");
		interface_label = new Label("Interface:");
		ip_label = new Label("IP:");
		maxspeed_label = new Label("MaxSpeed:");
		ylegend_label = new Label("YLegend:");
		short_label = new Label("ShortLegend:");
		legend1_label = new Label("Legend1:");
		legend2_label = new Label("Legend2:");
		legend3_label = new Label("Legend3:");
		legend4_label = new Label("Legend4:");
		legendi_label = new Label("LegendI:");
		legendo_label = new Label("LegendO:");
		info_label = new Label("Info:");
		info_field = new MultiLineLabel("                                      \n\n\n\n\n\n\n\n\n\n\n", 0, 30);

		// initializing all the text fields

		target_field = new TextField(40);
		port_field = new TextField(40);
		comm_field = new TextField(40);
		address_field = new TextField(40);
		oid1_field = new TextField(40);	
		oid2_field = new TextField(40);
		date_field = new TextField(40);
		creator_field = new TextField(40);
	//	comment_area = new TextArea(1, 40);

		comment_field = new TextField(40);

		title_field = new TextField(40);
		maxbytes_field = new TextField(40);
		absmax_field = new TextField(40);
		options_field = new TextField(40);
		x_field = new TextField(40);
		y_field = new TextField(40);
		unscaled_field = new TextField(40);
		with_peak_field = new TextField(40);
		colours_field = new TextField(40);
		page_field = new TextField(40);
		maintainer_field = new TextField(40);
		system_field = new TextField(40);
		interface_field = new TextField(40);
		ip_field = new TextField(40);
		maxspeed_field = new TextField(40);
		ylegend_field = new TextField(40);
		short_field = new TextField(40);
		legend1_field = new TextField(40);
		legend2_field = new TextField(40);
		legend3_field = new TextField(40);
		legend4_field = new TextField(40);
		legendi_field = new TextField(40);
		legendo_field = new TextField(40);
		status_field = new Label("Move the cursor over a description to get some information about it.");

		target_field.setBackground(Color.white);
		port_field.setBackground(Color.white);
		comm_field.setBackground(Color.white);
		address_field.setBackground(Color.white);
		oid1_field.setBackground(Color.white);
		oid2_field.setBackground(Color.white);
		date_field.setBackground(Color.white);
		creator_field.setBackground(Color.white);
	//	comment_area.setBackground(Color.white);

		comment_field.setBackground(Color.white);

		title_field.setBackground(Color.white);
		maxbytes_field.setBackground(Color.white);
		absmax_field.setBackground(Color.white);
		options_field.setBackground(Color.white);
		x_field.setBackground(Color.white);
		y_field.setBackground(Color.white);
		unscaled_field.setBackground(Color.white);
		with_peak_field.setBackground(Color.white);
		colours_field.setBackground(Color.white);
		page_field.setBackground(Color.white);
		maintainer_field.setBackground(Color.white);
		system_field.setBackground(Color.white);
		interface_field.setBackground(Color.white);
		ip_field.setBackground(Color.white);
		maxspeed_field.setBackground(Color.white);
		ylegend_field.setBackground(Color.white);
		short_field.setBackground(Color.white);
		legend1_field.setBackground(Color.white);
		legend2_field.setBackground(Color.white);
		legend3_field.setBackground(Color.white);
		legend4_field.setBackground(Color.white);
		legendi_field.setBackground(Color.white);
		legendo_field.setBackground(Color.white);

		// Buttons
		Left = new Button("<-");
		Right = new Button("->");
		save = new Button("OK");
  		close = new Button("Cancel");
  		revert = new Button("Reset");

		// create the panels and use gridbag layout for it

		panel1 = new Panel();
	 	button_panel = new Panel();	
		status_panel = new Panel();

		panel1.setLayout(gridbag);
		button_panel.setLayout(gridbag);
		status_panel.setLayout(gridbag);

		this.setBackground(Color.lightGray);


		// use constrain to add components

		//label_panel1
		AWTHelper.constrain(panel1, target_label, 0,0,1,1);
		AWTHelper.constrain(panel1, port_label, 0,1,1,1);
		AWTHelper.constrain(panel1, comm_label, 0,2,1,1);
		AWTHelper.constrain(panel1, address_label, 0,3,1,1);
		AWTHelper.constrain(panel1, oid1_label, 0,4,1,1);
		AWTHelper.constrain(panel1, oid2_label, 0,5,1,1);


		// panel1
		//AWTHelper.constrain(panel1, target_field, 1,0,1,1);
		AWTHelper.constrain(panel1,  target_field, 1,0,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,15);

		AWTHelper.constrain(panel1, port_field, 1,1,1,1);
		AWTHelper.constrain(panel1, comm_field, 1,2,1,1);
		AWTHelper.constrain(panel1, address_field, 1,3,1,1);
		AWTHelper.constrain(panel1, oid1_field, 1,4,1,1);		
		//AWTHelper.constrain(panel1, oid2_field, 1,5,1,1);

		AWTHelper.constrain(panel1, oid2_field, 1,5,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,10,0);


		AWTHelper.constrain(panel1, date_label, 2,0,1,1);
		AWTHelper.constrain(panel1, creator_label, 2,1,1,1);
		AWTHelper.constrain(panel1, comment_label, 2,2,1,1);
		AWTHelper.constrain(panel1, date_field, 3,0,1,1);
		AWTHelper.constrain(panel1, creator_field, 3,1,1,1);
		AWTHelper.constrain(panel1, comment_field, 3,2,1,1);

	
		AWTHelper.constrain(panel1, title_label, 0,7,1,1);
		AWTHelper.constrain(panel1, maxbytes_label, 0,8,1,1);
		AWTHelper.constrain(panel1, absmax_label, 0,9,1,1);
		AWTHelper.constrain(panel1, options_label, 0,10,1,1);
		AWTHelper.constrain(panel1, x_label, 0,11,1,1);
		AWTHelper.constrain(panel1, y_label, 0,12,1,1);
		AWTHelper.constrain(panel1, unscaled_label, 0,13,1,1);
		AWTHelper.constrain(panel1, with_peak_label, 0,14,1,1);
		//AWTHelper.constrain(panel1, colours_label, 0,15,1,1);
		AWTHelper.constrain(panel1, colours_label, 0,15,1,1, GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,10,0);

		AWTHelper.constrain(panel1, title_field, 1,7,1,1);
		AWTHelper.constrain(panel1, maxbytes_field, 1,8,1,1);
		AWTHelper.constrain(panel1, absmax_field, 1,9,1,1);
		AWTHelper.constrain(panel1, options_field, 1,10,1,1);
		AWTHelper.constrain(panel1, x_field, 1,11,1,1);
		AWTHelper.constrain(panel1, y_field, 1,12,1,1);
		AWTHelper.constrain(panel1, unscaled_field, 1,13,1,1);
		AWTHelper.constrain(panel1, with_peak_field, 1,14,1,1);
		AWTHelper.constrain(panel1, colours_field, 1,15,1,1);

		AWTHelper.constrain(panel1, page_label, 2,7,1,1);
		AWTHelper.constrain(panel1, maintainer_label, 2,8,1,1);
		AWTHelper.constrain(panel1, system_label, 2,9,1,1);
		AWTHelper.constrain(panel1, interface_label, 2,10,1,1);
		AWTHelper.constrain(panel1, ip_label, 2,11,1,1);
		AWTHelper.constrain(panel1, maxspeed_label, 2,12,1,1);

		AWTHelper.constrain(panel1, page_field, 3,7,1,1);
		AWTHelper.constrain(panel1, maintainer_field, 3,8,1,1);
		AWTHelper.constrain(panel1, system_field, 3,9,1,1);
		AWTHelper.constrain(panel1, interface_field, 3,10,1,1);
		AWTHelper.constrain(panel1, ip_field, 3,11,1,1);
		AWTHelper.constrain(panel1, maxspeed_field, 3,12,1,1);

		AWTHelper.constrain(panel1, ylegend_label, 0,16,1,1);
		AWTHelper.constrain(panel1, short_label, 0,17,1,1);
		AWTHelper.constrain(panel1, legend1_label, 0,18,1,1);
		AWTHelper.constrain(panel1, legend2_label, 0,19,1,1);
		AWTHelper.constrain(panel1, legend3_label, 0,20,1,1);
		AWTHelper.constrain(panel1, legend4_label, 0,21,1,1);
		AWTHelper.constrain(panel1, legendi_label, 0,22,1,1);
		AWTHelper.constrain(panel1, legendo_label, 0,23,1,1);

		AWTHelper.constrain(panel1, ylegend_field, 1,16,1,1);
		AWTHelper.constrain(panel1, short_field, 1,17,1,1);
		AWTHelper.constrain(panel1, legend1_field, 1,18,1,1);
		AWTHelper.constrain(panel1, legend2_field, 1,19,1,1);
		AWTHelper.constrain(panel1, legend3_field, 1,20,1,1);
		AWTHelper.constrain(panel1, legend4_field, 1,21,1,1);
		AWTHelper.constrain(panel1, legendi_field, 1,22,1,1);
		AWTHelper.constrain(panel1, legendo_field, 1,23,1,1);

		AWTHelper.constrain(panel1, info_label, 2,16,1,1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(panel1, info_field, 3,16,1,8, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);

		AWTHelper.constrain(button_panel, Left, 0,0,1,1, GridBagConstraints.NONE, GridBagConstraints.WEST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(button_panel, save, 1,0,1,1, GridBagConstraints.NONE, GridBagConstraints.CENTER, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(button_panel, close, 2,0,1,1, GridBagConstraints.NONE, GridBagConstraints.CENTER, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(button_panel, revert, 3,0,1,1, GridBagConstraints.NONE, GridBagConstraints.CENTER, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(button_panel, Right, 4,0,1,1, GridBagConstraints.NONE, GridBagConstraints.EAST, 0.0,0.0,0,0,0,0);
		AWTHelper.constrain(status_panel, status_field, 0,0,1,1, GridBagConstraints.BOTH, GridBagConstraints.NORTHWEST, 0.0,0.0,0,0,0,0);

		// use gridbag layout to arrange the panels
		this.setLayout(gridbag);
		// and put them into top level window

		AWTHelper.constrain(this, panel1, 0,0,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,10,10,10,10);
	//	AWTHelper.constrain(this, panel2, 1,0,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,5,5,5);
	//	AWTHelper.constrain(this, panel3, 0,1,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,5,5,5);
	//	AWTHelper.constrain(this, panel4, 1,1,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,5,5,5);
	//	AWTHelper.constrain(this, panel5, 0,2,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,5,5,5);
	//	AWTHelper.constrain(this, panel6, 1,2,1,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,5,5,5);
		AWTHelper.constrain(this, button_panel, 0,3,2,1,GridBagConstraints.HORIZONTAL, GridBagConstraints.CENTER, 0.0,0.0,5,10,5,10);
		AWTHelper.constrain(this, status_panel, 0,4,2,1,GridBagConstraints.NONE, GridBagConstraints.NORTHWEST, 0.0,0.0,5,10,10,10);
	
		status("Please edit the target. Go to previous or next target using the arrow buttons.");
		loadTarget(current, temp);

		// register all the listeners

		// mouse enter listeners

			this.info_field.addMouseListener(new showInfo("This is the info field. To get some \n" +
			"information about an item, move the mouse over its textfield."));	

			this.target_field.addMouseListener(new showInfo("This is the name of the target. \n" +
			"It will be used for the webpages, logfiles and gifs created for that target.\n" +
			"It is recommended to use the following naming scheme:\n" +
			"'host/routername_ip-of-subnet_oid'.\n\n" +
			"host/routername: the name of the host or router at which the target is\n" +
			"ip_of_subnet: if there's a subnet connected to the target interface, its ip,\n" +
			"if not the hostname or ip of the connection partner.\n" +
			"oid: the oid or name of the SNMP variable if not In/OutOctets."));

			this.port_field.addMouseListener(new showInfo("This is the number of the SNMP Port.\n" +
			"Normally, this is set automatically." +
			"\nFormat:\n" +
			"Any number between 1 and 256."));

			this.comm_field.addMouseListener(new showInfo("This is the  SNMP Community of the device.\n" +
			"Normally, this is set to 'public'."));

			this.address_field.addMouseListener(new showInfo("This is the  IP adress or hostname of the interface."));
	
			this.oid1_field.addMouseListener(new showInfo("This is the first of the two SNMP OIDs of the interface.\n" +
			"If this field is empty, ifInOctets is the default.\n" +
			"You can either write the OID as a Number (e.g. 1.3.6.1.2.1.2.2.10 for the \n" +
			"ifInOctets) or use some predefined values:\n" +
			"ifInOctets: Number of bytes; default value if empty\n" +
			"ifInErrors: Errors on the interface\n" +
			"ifInUcastPkts: Number of unicast packets\n" +
			"ifInNUcastPkts: Number of non-unicast (broadcast) packets\n" +
			"ifInDiscards: Number of discarded packets"));

			this.oid2_field.addMouseListener(new showInfo("This is the second of the two SNMP OIDs of the interface.\n" +
			"If this field is empty, ifOutOctets is the default.\n" +
			"Some predefined values:\n" +
			"ifOutOctets: Number of bytes; default value if empty\n" +
			"ifOutErrors: Errors on the interface\n" +
			"ifOutUcastPkts: Number of unicast packets\n" +
			"ifOutUcastPkts: Number of non-unicast (broadcast) packets\n" +
			"ifOutDiscards: Number of discarded packets\n" +
			"Note: You have to fill in none of the two OIDs or both."));


			this.date_field.addMouseListener(new showInfo("This is the date of creation of this entry.\n" +
			"It will be set automatically for you, but you can\n" +
			"change it if needed."));

			this.creator_field.addMouseListener(new showInfo("This is the name of the creator of this entry (you).\n" +
			"Please fill it in for future reference."));

		//	this.comment_area.addMouseListener(new showInfo("This field can be used to enter some comment about the target.\n" +
		//	"Note: the comment should be one single line, so don't use the return key."));
	
			this.comment_field.addMouseListener(new showInfo("This field can be used to enter some comment about the target.\n" +
			"Note: the comment should be one single line, so don't use the return key."));
	
			this.title_field.addMouseListener(new showInfo("This will be the title of the HTML file."));

			this.maxbytes_field.addMouseListener(new showInfo("The maximum rate of the interface in BYTES.\n" +
			"To get the byte rate, divide the bitrate by 8.\n" +
			"10 Mbit/s Ethernet -> 1250000 bytes/s\n"));

			this.absmax_field.addMouseListener(new showInfo("This is the absolute maximum value ever to be reached.\n" +
			"This is necessary if you monitor a link which can handle more traffic\n" +
			"than the MaxBytes value (e.g. if compression is used, or some frame\n" +
			"relay link). If this value is not set, all values higher than MaxBytes \n" +
			"will be ignored."));

			this.options_field.addMouseListener(new showInfo("This allows you to set some boolean switches.\n" +
			"bits - numbers are printed in bits instead of bytes.\n" +
			"absolute - data sources wich reset their values when they are read.\n" +
			"gauge - values are absolute (e. g. diskspace)\n" +
			"Format: bits, absolute, gauge - options divided by commas"));

			this.x_field.addMouseListener(new showInfo("This is the horizontal size of the graph.\n" +
			"By default, graphs are 400 pixel wide (and 100 pixel high).\n" +
			"A good value for this is 600 (x 150).\n" +
			"If you specify XSize, it's a good idea to specify YSize as well."));
		
			this.y_field.addMouseListener(new showInfo("This is the vertical size of the graph.\n" +
			"By default, graphs are 100 pixel high (and 400 pixel wide).\n" +
			"A good value for this is 150 (x 600).\n" +
			"If you specify YSize, it's a good idea to change XSize as well."));

			this.unscaled_field.addMouseListener(new showInfo("By default, each graph is scaled vertically.\n" +
			"This can be suppressed with Unscaled.\n" +
			"Format:\n" +
			"dwmy - for each graph a letter: d(ay) w(eek) m(onth) y(ear)"));

			this.with_peak_field.addMouseListener(new showInfo("By default, average values are used for the graphs.\n" +
			"If you want peak values instead, use this option.\n" +
			"Format:\n" +
			"dwmy - for each graph a letter: d(ay) w(eek) m(onth) y(ear)"));

			this.colours_field.addMouseListener(new showInfo("The 'Colours' tag allows you to override the default colour scheme.  \n" +
			"Note: All 4 of the required colours must be specified here.\n" +
			"\nFormat is: Colour1#RRGGBB,Colour2#RRGGBB,Colour3#RRGGBB,\n" +
			"Colour4#RRGGBB, where: \n" +
			"Colour1 = Input on default graph; Colour2 = Output on default graph;\n" +
			"Colour3 = Max input; Colour4 = Max output; \n" +
			"RRGGBB  = 2 digit hex values for Red, Green and Blue"));

			this.page_field.addMouseListener(new showInfo("This is the title on top the HTML Page.\n" +
			"It is recommended to use something similar to the Title to the left."));

			this.maintainer_field.addMouseListener(new showInfo("This is the name of the system maintainer.\n" +
			"This should be specified as a SNMP variable in the device,\n" +
			"however, you can change it here."));

			this.system_field.addMouseListener(new showInfo("This is the system's name.\n" +
			"This should be specified as a SNMP variable in the device,\n" +
			"however, you can change it here."));

			this.interface_field.addMouseListener(new showInfo("This is the interface's name.\n" +
			"This should be specified as a SNMP variable in the device,\n" +
			"however, you can change it here."));

			this.ip_field.addMouseListener(new showInfo("This is the interface's IP or hostname.\n" +
			"This should be specified as a SNMP variable in the device,\n" +
			"however, you can change it here."));

			this.maxspeed_field.addMouseListener(new showInfo("This is the interface's maximum speed.\n" +
			"It has only informal character.\n" +
			"This should be specified as a SNMP variable in the device,\n" +
			"however, you can change it here."));

			this.ylegend_field.addMouseListener(new showInfo("This is the Legend for the Y axis legend.\n" +
			"Default is: Bytes/Bits per second, dependig on Option."));

			this.short_field.addMouseListener(new showInfo("This is the 'b/s' string vor the Max, Average and Current values \n" +
			"below the graph.\n" +
			"Default is: b/s"));

			this.legend1_field.addMouseListener(new showInfo("This allows you to override the text displayed for the color legend 1.\n" +
			"Default is: Not specified"));

			this.legend2_field.addMouseListener(new showInfo("This allows you to override the text displayed for the color legend 2.\n" +
			"Default is: Not specified"));

			this.legend3_field.addMouseListener(new showInfo("This allows you to override the text displayed for the color legend 3.\n" +
			"Default is: Not specified"));

			this.legend4_field.addMouseListener(new showInfo("This allows you to override the text displayed for the color legend 4.\n" +
			"Default is: Not specified"));

			this.legendi_field.addMouseListener(new showInfo("This allows you to override the text displayed for the In legend.\n" +
			"Default is: In"));

			this.legendo_field.addMouseListener(new showInfo("This allows you to override the text displayed for the Out legend.\n" +
			"Default is: Out"));

			this.save.addMouseListener(new showInfo("Return to the MC2 window."));

			this.revert.addMouseListener(new showInfo("Discard your edits and start over with this target."));

			this.close.addMouseListener(new showInfo("Closes the edit window."));

			this.Left.addMouseListener(new showInfo("Scrolls one target up."));

			this.Right.addMouseListener(new showInfo("Scrolls one Target down."));

		// action listeners
			this.save.addActionListener(new SaveHandler());
			this.revert.addActionListener(new RevertHandler());
			this.close.addActionListener(new CloseHandler());
			this.Left.addActionListener(new LeftHandler());
			this.Right.addActionListener(new RightHandler());
			this.addWindowListener(new WindowHandler());

	}


	// Feeding data into the fields

	/** gives back a line if not empty
	 *
	 * @param c	int with current target
	 * @param option	String with option name
	 * @param field		Textfield to put value into
	 * @param f		CFG from which to load
	 * @return Value of entry or empty String if it was empty
	 */
	public void fillValue(int c, String option, TextField field, Cfg f) {
		field.setText(f.getValue(c, option));
	}


	/** loads the data of the current target into the textfields.
	 * @param current	int with active target
	 * @param f		CFG from which to load
	 */
	public void loadTarget(int current, Cfg f) {
		
		// if no date specified, set automatic date

		Date datum = new Date(); // initialize a date object with currend date
		String dateStr = datum.toString();

		String str=file.getValue(current, "Date");
		if (str.equals("")) {
			date_field.setText(dateStr);
		}
		else {
			date_field.setText(str);
		}

		fillValue (current, "Target", this.target_field, f);
		fillValue (current, "Port", this.port_field, f);
		fillValue (current, "Community", this.comm_field, f);
		fillValue (current, "Address", this.address_field, f);
		fillValue (current, "OID1", this.oid1_field, f);
		fillValue (current, "OID2", this.oid2_field, f);
		fillValue (current, "Creator", this.creator_field, f);
		fillValue (current, "Title", this.title_field, f);
		fillValue (current, "MaxBytes", this.maxbytes_field, f);
		fillValue (current, "AbsMax", this.absmax_field, f);
		fillValue (current, "Options", this.options_field, f);
		fillValue (current, "XSize", this.x_field, f);
		fillValue (current, "YSize", this.y_field, f);
		fillValue (current, "Unscaled", this.unscaled_field, f);
		fillValue (current, "WithPeak", this.with_peak_field, f);
		fillValue (current, "Colours", this.colours_field, f);
		fillValue (current, "PageTopTitle", this.page_field, f);
		fillValue (current, "Maintainer", this.maintainer_field, f);
		fillValue (current, "System", this.system_field, f);
		fillValue (current, "Interface", this.interface_field, f);
		fillValue (current, "IP", this.ip_field, f);
		fillValue (current, "MaxSpeed", this.maxspeed_field, f);
		fillValue (current, "YLegend", this.ylegend_field, f);
		fillValue (current, "ShortLegend", this.short_field, f);
		fillValue (current, "Legend1", this.legend1_field, f);
		fillValue (current, "Legend2", this.legend2_field, f);
		fillValue (current, "Legend3", this.legend3_field, f);
		fillValue (current, "Legend4", this.legend4_field, f);
		fillValue (current, "LegendI", this.legendi_field, f);
		fillValue (current, "LegendO", this.legendo_field, f);

		fillValue (current, "Comment", this.comment_field, f);


		// the same for the text area
		status("Target loaded.                                                                                                                                                                                               ");
	}

	protected void closeAll() {
		// save dialog
		status("Closing...");
		saveTarget(current);
		close_dialog = new YesNoDialog(et, "Discard?", "Discard your Edits?", "No", "Yes", "Cancel");
		close_dialog.yes.addActionListener(new DialogYes());
		close_dialog.no.addActionListener(new DialogNo());
		close_dialog.cancel.addActionListener(new DialogCancel());
		close_dialog.addWindowListener(new DialogWindow());
		close_dialog.show();
	}


	/** saves a line if not empty
	 *
	 * @param current	int with current target
	 * @param option	String with option name
	 * @param field		Textfield to get value from
	 * @return <code>true</code> if ok <code>false</code>otherwise.
	 */
	public boolean saveValue(int c, String option, TextField field) {
		return temp.setValue(current, option, field.getText());
	}


	/** saves the data of the current target into temp CFG file.
	 * @param current	int with active target
	 */
	public boolean saveTarget(int current) {
		
		// put the text into the text fields
		boolean b;

		b = saveValue (current, "Target", this.target_field);
		b &= saveValue (current, "Port", this.port_field);
		b &= saveValue (current, "Community", this.comm_field);
		b &= saveValue (current, "Address", this.address_field);
		b &= saveValue (current, "OID1", this.oid1_field);
		b &= saveValue (current, "OID2", this.oid2_field);
		b &= saveValue (current, "Date", this.date_field);
		b &= saveValue (current, "Creator", this.creator_field);		
		b &= saveValue (current, "Title", this.title_field);
		b &= saveValue (current, "MaxBytes", this.maxbytes_field);
		b &= saveValue (current, "AbsMax", this.absmax_field);
		b &= saveValue (current, "Options", this.options_field);
		b &= saveValue (current, "XSize", this.x_field);
		b &= saveValue (current, "YSize", this.y_field);
		b &= saveValue (current, "Unscaled", this.unscaled_field);
		b &= saveValue (current, "WithPeak", this.with_peak_field);
		b &= saveValue (current, "Colours", this.colours_field);
		b &= saveValue (current, "PageTopTitle", this.page_field);
		b &= saveValue (current, "Maintainer", this.maintainer_field);
		b &= saveValue (current, "System", this.system_field);
		b &= saveValue (current, "Interface", this.interface_field);
		b &= saveValue (current, "IP", this.ip_field);
		b &= saveValue (current, "MaxSpeed", this.maxspeed_field);
		b &= saveValue (current, "YLegend", this.ylegend_field);
		b &= saveValue (current, "ShortLegend", this.short_field);
		b &= saveValue (current, "Legend1", this.legend1_field);
		b &= saveValue (current, "Legend2", this.legend2_field);
		b &= saveValue (current, "Legend3", this.legend3_field);
		b &= saveValue (current, "Legend4", this.legend4_field);
		b &= saveValue (current, "LegendI", this.legendi_field);
		b &= saveValue (current, "LegendO", this.legendo_field);


		return b &= saveValue (current, "Comment", this.comment_field);

		// the same for the text area
	//	String s=comment_area.getText();
	//	return b &= temp.setValue(current, "Comment", s);

	}


//------------------------------------------------HELPER METHODS-------------------------------------------

	// puts some text into info_field (just hides the method in MultiLineLabel)
	private void message(String s) {
		info_field.setLabel(s);
	}

	// puts some text into status_field (just hides the method in MultiLineLabel)
	private void status(String s) {
		status_field.setText(s);
	}

	public void main (String argv[]) {
		// does nothing for the moment
	}


//--------------------------------------------------- INNER CLASSES -----------------------------


	// INNER CLASSES
	/** Inner class with the event handler for the mouse enter events. 
	 *
	 * @param s	String with the explanation
	 */
	class showInfo extends MouseAdapter {

		String s; // the text

		// Constructor
		showInfo(String s) {
			this.s = s;
		}
		
		public void mouseEntered(MouseEvent e) {
			message(s);
		}
	}


	/** Inner class for handling the action event -- save button.
	 */
	class SaveHandler implements ActionListener {

		// write it back to CFG
		public void actionPerformed(ActionEvent e) {
			if(saveTarget(current)) {
				status("Saving .... ");
				parent.saveCfg(et.temp); // UPCALL: Change it in final release
				et.dispose();
			}
			else {
				AWTHelper.warn("Couldn't save.");
			}	
		}
	}


	/** Inner class for handling the action event -- revert button.
	 */
	class RevertHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			// just load it once again
			// write it back to CFG
			loadTarget(current, file);
		}
	}


	/** Inner class for handling the action event -- close button.
	 */
	class CloseHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			closeAll();
		}
	}


	/** Inner class for handling the action event -- left button.
	 */
	class LeftHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			// put data of target before this
			if (current > 0) {
				status("Loading previous target...");
				if (saveTarget(current)) {
					current--;
					loadTarget(current, temp);
				}
				else {
					status("Couldn't save target " + current);
				}
			}
		}
	}


	/** Inner class for handling the action event -- right button.
	 */
	class RightHandler implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			// put in data of the next target
			if (current < (temp.Targets.size() - 1)) {
				status("Loading next Target...");
				if (saveTarget(current)) {
					current++;
					loadTarget(current, temp);
				}
				else {
					status("Couldn't save target " + current);
				}
			}
		}
	}


	/** Inner class for handling the window close event.
	 */
	class WindowHandler extends WindowAdapter {

		public void windowClosing(WindowEvent e) {
			closeAll();
		}
	}


// ---------------------------------------- CloseDialog -------------------------------------


	/** Inner class for handling the action event of the yes no dialog-- yes button.
	 */
	class DialogYes implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			close_dialog.kill();
			if(saveTarget(current)) {
				status("Saving .... ");
				parent.saveCfg(et.temp); // UPCALL: Change it in final release
				et.setVisible(false);
				et.dispose();
			}
			else {
				AWTHelper.warn("Couldn't save.");
			}
		}
	}


	/** Inner class for handling the action event of the yes no dialog-- no button.
	 */
	class DialogNo implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			close_dialog.kill();
			et.setVisible(false);
			et.dispose();

		}
	}


	/** Inner class for handling the action event of the yes no dialog-- cancel button.
	 */
	class DialogCancel implements ActionListener {

		public void actionPerformed(ActionEvent e) {
			close_dialog.kill();
		}
	}


	/** Inner class for handling the action event of the yes no dialog-- cancel button.
	 */
	class DialogWindow extends WindowAdapter {

		public void windowClosing(ActionEvent e) {
			close_dialog.kill();
		}
	}
}
