package ch.swisslife.ibgm.mc2;
import java.util.*;
 
 
 /** Creates from the data in the Cfg data structure the syntax of a CFG file. 
 * It uses the OutputChannel class to open a connection to the cgi and to send it line by line.
 * It supports only the WRITE mode, DELETE mode must be accessed directly in OutputChanel.
 *
 * @author	Michael Grob for RA/SL
 * @version	1.01 09/04/98
 *
 */
public class Distiller {

	private Cfg file;	// the Cfg which will contain the data
	private OutputChannel output; 
	public String BACKUP_URL, CGI;


	/** Constructor for this class with a Cfg as argument. This will instantiate the
	 * class and define the Cfg data structure to work with.
	 *
	 * @param file		Cfg that will be written to document
	 * @param backupURL 	String with the URL where the backup files are stored
	 * @param cfgwriter	String with the URL of the cgi script
	 */
	public Distiller(Cfg f, String backupURL, String cfgwriter) {
		this.super();
		BACKUP_URL = backupURL;
		CGI = cfgwriter;
		file = f;
		output = new OutputChannel("WRITE", f.Url, BACKUP_URL, CGI);
		if (output.connectionIsOpen == false) {
			AWTHelper.warn("Could not open connection to cgi");
		}	
	}
	

	/** prints the in the argument specified line to the output.
	 *
	 * @param line	String with the line to be printed.
	 */
	private void addLine(String line) {
		if (line != "") {
			if (output.connectionIsOpen){
				if (output.sendLine(line+" & ") == false) {
					AWTHelper.warn("Could not write line to cgi.");
				}
			}
		}
	}
				
	
	/* Starts the translation into a mrtg-readable Cfg-File and gives back
	 * <code>true</code> if successfull, <code>false</code> otherwise.
	 *
	 * @return	<code>true</code> if successfull,<code>false</code> otherwise.
	 */
	public boolean successful() {
		
		int current = 0; 	// active target
		String option;
					
 		if (file.isEmpty()) {
				AWTHelper.warn(" there was no data in the file ");
			}

 		else {
				// print out the whole Cfg in format param=text
				// some ints for indexing the params (so the're in correct order)

				int target_array[] = {0,0,1};

				// initialize a date object with currend date
				Date datum = new Date(); 
				String dateStr = datum.toString();
				addLine("p000-00=# This is a config file for mrtg 2.5.x.");
				addLine("p000-01=# It was auto-created by mc2.\n");
				addLine("p000-02=\n# Created " + dateStr + "\n");
				addLine("p000-03=# Some entries for all targets: ");
				addLine("p000-04=WorkDir: " + file.getValue( "WorkDir"));
				addLine("p000-05=IconDir: " + file.getValue( "IconDir"));
				addLine("p000-06=Refresh: " + file.getValue("Refresh"));
				addLine("p000-07=Interval: " + file.getValue("Interval"));
				addLine("p000-11=\n# ########################################");
				addLine("p000-12=# Configuration for each target to monitor");
				addLine("p000-13=# ########################################\n");
					
				// do this for each target: get the values and print them out
				int max = file.getNumberOfTargets();
			
				while (current < max) {
					// for every target
					String target_index=Integer.toString(target_array[0]) + Integer.toString(target_array[1]) + Integer.toString(target_array[2]);
					String target = file.getValue(current, "Target");

					//creator, creation date, target
					addLine("p"+target_index+"-00=\n# Creator Information\n");
					addLine("p"+target_index+"-01=# Date[" + target + "]: " + file.getValue(current, "Date"));
					//addLine("p"+target_index+"-02=# Creator[" + target + "]: " + file.getValue(current, "Creator"));
					writeline(current, "Creator", target,"p"+target_index+"-02=# ");		

					addLine("p"+target_index+"-03=# Comment[" + target + "]: " + file.getValue(current, "Comment")+"\n");
			
					// put together target line
					String port = file.getValue(current, "Port");
					String comm = file.getValue(current, "Community");
					String address = file.getValue(current, "Address");
					if ((!file.getValue(current, "OID1").equals("")) & (!file.getValue(current, "OID2").equals(""))) {
						// do it with OID..
						String oid1 = file.getValue(current, "OID1");
						String oid2 = file.getValue(current, "OID2");
						String buf = "Target[" + target + "]: ";
						buf += oid1 + "." + port + "&";
						buf += oid2 + "." + port + ":" + comm;
						buf += "@" + address;
						addLine("p"+target_index+"-04="+buf);
					}
					else {

						if(port.equals("")) {
							// we got an external source
							addLine("p"+target_index+"-04=Target[" + target + "]:" + address);
						}
						else {
							addLine("p"+target_index+"-04=Target[" + target + "]: " + port + ":" + comm + "@" + address);
						}
					}
					
					// all the other lines
					// print them out only if they`re not empty
					addLine("p"+target_index+"-05=MaxBytes[" + target + "]: " + file.getValue(current, "MaxBytes"));
					addLine("p"+target_index+"-06=Title[" + target + "]: " + file.getValue(current, "Title"));
					// PageTop
					addLine("p"+target_index+"-07=PageTop[" + target + "]: <H1>" + file.getValue(current, "PageTopTitle"));
					addLine("p"+target_index+"-08= </H1>\n <TABLE>");
					addLine("p"+target_index+"-09=   <TR><TD>System:</TD><TD>" + file.getValue(current, "System") + "</TD></TR>");
					addLine("p"+target_index+"-10=   <TR><TD>Maintainer:</TD><TD>" + file.getValue(current, "Maintainer") + "</TD></TR>");
					addLine("p"+target_index+"-11=   <TR><TD>Interface:</TD><TD>" + file.getValue(current, "Interface") + "</TD></TR>");
					addLine("p"+target_index+"-12=   <TR><TD>IP:</TD><TD>" + file.getValue(current, "IP") + "</TD></TR>");	
					addLine("p"+target_index+"-13=   <TR><TD>MaxSpeed:</TD>");
					addLine("p"+target_index+"-14=     <TD>" + file.getValue(current, "MaxSpeed") + "</TD></TR>\n </TABLE>");
		
					writeline(current, "AbsMax", target,"p"+target_index+"-15=");		
					writeline(current, "XSize", target,"p"+target_index+"-16=");
					writeline(current, "YSize", target,"p"+target_index+"-17=");
					writeline(current, "Options", target,"p"+target_index+"-18=");
					writeline(current, "Unscaled", target,"p"+target_index+"-19=");	
					writeline(current, "WithPeak", target,"p"+target_index+"-20=");	
					writeline(current, "Colours", target,"p"+target_index+"-21=");	
					writeline(current, "YLegend", target,"p"+target_index+"-22=");
					writeline(current, "ShortLegend", target,"p"+target_index+"-23=");		
					writeline(current, "Legend1", target,"p"+target_index+"-24=");
					writeline(current, "Legend2", target,"p"+target_index+"-25=");
					writeline(current, "Legend3", target,"p"+target_index+"-26=");
					writeline(current, "Legend4", target,"p"+target_index+"-27=");
					writeline(current, "LegendI", target,"p"+target_index+"-28=");
					writeline(current, "LegendO", target,"p"+target_index+"-29=");
					addLine("p"+target_index+"99=\n\n#--------------------------------------------------------------\n\n");
						
					current++;
				
					if (target_array[2] == 9) {
						target_array[2] = 0;
						target_array[1]++;
						if (target_array[1] == 9) {
							target_array[1] = 0;
							target_array[0]++;
							if (target_array[0] == 9) {
								AWTHelper.warn("Too many targets, cannot format Output.");
							}
						}
					}
					else {
						target_array[2]++;
					}
				}
				
				// everything seems to be ok
				if (output.closeConnection()) {
					return true;
				}
			} // of else
		// something was wrong... :-(
		return false;	
	}

	private void writeline(int current, String arg, String target, String param) {
		String option = file.getValue(current, arg);
		if (! option.equals("")) {
			addLine(param+arg + "[" + target + "]: " + option);
		}
	}


	public void main(String[] argv) {
		// do nothing
	}

}
