#############################################################################
# Version 2.0c
# Date: 24-08-2001
# Author: Rolph Haspers
# Read the readme provided with this script
#############################################################################
# Based on gb.php 
# Version 0.9 (c) 2001
# Version 1.9 (c) 2001
#              - Vincent Houwert (vincent@trueserver.nl)
#              - Marcel Leicher (marcel@silverpoint.nl)
#############################################################################
# remove the # if you would like to use a default background image. Change the location 
# to the location of the image. Must be a PNG image.
# my $baseimg = "C:/perl/stats/data/fun.png";
#
# you can give the bars your own color, these are rgb settings. Use HTML color-coding.
# my ($redin, $greenin, $bluein) = (100,100,100);	#color for in-traffic
# my ($redout, $greenout, $blueout) = (100,100,100);	#color for out-traffic
#
# Specify the directory where the .data files are located. The .data file may also be located
# under a subdirectory in this directory. Check the readme for this case.
$DOCUMENT_ROOT = "C:/perl/stats/work/";
#
###################### NOTHING HAS TO BE CHANGED BELOW ######################
use GD;
use POSIX;

&parse_form;
$host = $FORM{'host'};	#Get hostname from QueryString
$maandb = $FORM{'month'};	#Get monthnumber from queyystring (1..12)

@bytesformat = (["id",0, 1, 2, 3, 4, 5],
				[1,"B", "KB", "MB", "GB", "TB", "PB"],
				["2","Bytes", "KiloBytes", "MegaBytes", "GigaBytes", "TeraBytes", "PetaBytes"]
);

@maanden = ("January", "Februari", "March", "April", "May", "June", "July", "August", "September", "Oktober", "November", "December");

# Day in Month
($seconds, $minutes, $hour, $monthday, $month, $year, $weekday, $yearday, $isdist) = localtime(time);

if (!($maandb eq '')) {
	if ($maandb < 1 || $maandb > 12) {
		$maand = $month+1;
	} else {	
		$maand = $maandb;
	}
} else {
	$maand = $month+1;
}

if ($maand > $month+1) { $year = $year - 1;}
if (length($maand)!='2') { $maanda = '0'.$maand; } else { $maanda = $maand; };
$jaar = $year + 1900;
$dim = strftime ("%d", 0,0,0,0,$maand,$year);

sub formatBytes {
	my ($waarde, $weergave) = @_;
	# bij weergaven is 0 als int terug geven, short=korte notatie en 2=lange notatie
	if ($waarde/1024/1024/1024/1024/1024 > 1)	{ 
		$waarde = sprintf("%0.2f",$waarde/1024/1024/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][6];
		};
	}
	elsif ($waarde/1024/1024/1024/1024 > 1)  		{ 
		$waarde = sprintf("%0.2f",$waarde/1024/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][5];
		};
	}
	elsif ($waarde/1024/1024/1024 > 1)  			{ 
		$waarde = sprintf("%0.1f",$waarde/1024/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][4];
		};
	}
	elsif ($waarde/1024/1024 > 1)   				{ 
		$waarde = sprintf("%0.1f",$waarde/1024/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][3];
		};
	}
	elsif ($waarde/1024 > 1)    					{ 
		$waarde = sprintf("%0.1f",$waarde/1024);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][2]; 
		};
	}
	else	                    					{ 
		$waarde = sprintf("%0.1f",$waarde);
		if ($weergave) {
			$waarde .= " ".$bytesformat[$weergave][1]; 
		};
	};
	return $waarde;
};

################################ MAIN PROGRAM ############################### #
# begin met een basis plaatje

if ($baseimg) {
	$im = newFromPng GD::Image("$baseimg");
	# Kleuren:
	if ($redin && $greenin && $bluein) { 
		$grc = $im->colorAllocate($redin, $greenin, $bluein);
		$grc2 = $im->colorAllocate($redin, $greenin+20, $bluein);
	} else { 
		$grc = $im->colorAllocate(0, 200, 0); 
		$grc2 = $im->colorAllocate(0, 220, 0); 
	};
	if ($redout && $greenout && $blueout) { 
		$rood = $im->colorAllocate($redout, $greenout, $blueout);
		$rood2 = $im->colorAllocate($redout+20, $greenout, $blueout);
	} else { 
		$rood = $im->colorAllocate(200, 0, 0); 
		$rood2 = $im->colorAllocate(220, 0, 0); 
	};
	$tc = $im->colorAllocate(0, 0, 0);
	$avgc = $im->colorAllocate(0, 0, 200); 
	$grijs = $im->colorAllocate(180, 180, 180);
} else {
	$y = 170;
	$x = 500;
	$im = new GD::Image($x,$y);
	$wit = $im->colorAllocate(250, 250, 250);
	$up = $im->colorAllocate(200,200,200);
	$down = $im->colorAllocate(100,100,100);
	$tc = $im->colorAllocate(0,0,0);
	#vullen met kleur wit
	$im->fill(0, 0, $wit);
	#maken van de grijze rand
	$bot = $y-1;
	$bot2 = $y-2;
	$bot3 = $y-3;
	$rig = $x-1;
	$rig2 = $x-2;
	$rig3 = $x-3;
	$im->line(0,0,0,$bot, $up);
	$im->line(1,1,1,$bot2, $up);
	$im->line(0,0,$rig,0, $up);
	$im->line(1,1,$rig2,1, $up);
	$im->line($rig,0,$rig,$bot,$down);
	$im->line($rig2,1,$rig2,$bot2,$down);
	$im->line(0,$bot,$rig,$bot,$down);
	$im->line(1,$bot2,$rig2,$bot2,$down);
	#horizontale lijnen ofziets voor de box?
	$im->line(79, 14, ($dim==31?488:483), 14, $tc);
	$im->line(79, 39, ($dim==31?488:483), 39, $tc);
	$im->line(79, 64, ($dim==31?488:483), 64, $tc);
	$im->line(79, 89, ($dim==31?488:483), 89, $tc);
	# Kleuren:
		if ($redin && $greenin && $bluein) { 
		$grc = $im->colorAllocate($redin, $greenin, $bluein);
		$grc2 = $im->colorAllocate($redin, $greenin+20, $bluein);
	} else { 
		$grc = $im->colorAllocate(0, 200, 0); 
		$grc2 = $im->colorAllocate(0, 220, 0); 
	};
	if ($redout && $greenout && $blueout) { 
		$rood = $im->colorAllocate($redout, $greenout, $blueout);
		$rood2 = $im->colorAllocate($redout+20, $greenout, $blueout);
	} else { 
		$rood = $im->colorAllocate(0, 0, 200); 
		$rood2 = $im->colorAllocate(0, 0, 220); 
	};
	#tc=zwart, avgc=blauw (gemiddelde lijn)
	$tc = $im->colorAllocate(0, 0, 0);
	$avgc = $im->colorAllocate(0, 0, 200); 
	$grijs = $im->colorAllocate(180, 180, 180);
	
	#de horizontale witte lijnen (dotted lijnen)
	for ($j=82; $j<485; $j++) {
	   $im->line($j, 15, $j, 113, $wit);
	   $j++;
	   $im->line($j, 15, $j, 113, $wit);
	   $j++;
	}
	#afmaken van de box en neerzetten 0.0 in de linkeronderhoek
	$im->line(79, 114, 488, 114, $tc);
	$im->rectangle(81, 14, 486, 114, $tc);
	$im->string(gdSmallFont, 41, 108, "0.0", $tc);
};

# file opzoeken in in array dumpen
# openen data file en alles inlezen en in een array gooien genaamd $rawdata
# $DOCUMENT_ROOT\/$host\.data
if (-e "$DOCUMENT_ROOT$host\.data") {
	open(IN, "$DOCUMENT_ROOT$host\.data");
	while(<IN>) {
		@temp_arr = split;
		push @rawdata, [ @temp_arr ];
	}
} else {
#als er iets fout is gegaan een error ding maken	
	$error = "File ".$DOCUMENT_ROOT.$host.".data does not exists, exiting";
};

# array opschonen, hoogste bepalen
# doorlopen array
$k=0;
$xmax=0;
@hoogst = ("",0);
for $j (0 .. $#rawdata ) {
	#splitten op tab? formaat was jaarmaanddag    bytes
	#alle data van de gevraagde maand $jaar$maanda in een array opslaan
	$string=$rawdata[$j][0];
	for ($string) {
        s/^\s+//;
        s/\s+$//;
    }
	if (substr($string,0,6)==$jaar.$maanda) {
		$x = substr($string,6,2) - 1;
		#datum in datum array opslaan
		$data[0][$x] = $string;
		#bytes van datum in bytes array opslaan
		$data[1][$x] += $rawdata[$j][1];	#in
		$data[2][$x] += $rawdata[$j][2];	#out		
		#kijken of bytes > hoogste dan opslaan in hoogste array
		if (($data[1][$x]>$hoogst[1] && $data[1][$x]>$hoogst[2]) || ($data[2][$x]>$hoogst[1] && $data[2][$x]>$hoogst[2])){
			$hoogst[0] = $data[0][$x];
			$hoogst[1] = $data[1][$x];
			$hoogst[2] = $data[2][$x];
		};
		if($data[1][$x]+$data[2][$x]>$piek[1]) {
			$piek[0] = $data[0][$x];
			$piek[1] = $data[1][$x]+$data[2][$x];
		}
		if ($x > $xmax) { $xmax = $x; }
	};
};
$k=$xmax+1;
if ($error) {
	$im->string(gdSmallFont,  175, 50, "Data file currently not available", $tc);
	$im->string(gdSmallFont,  160, 67, "at ".$DOCUMENT_ROOT.$host.".data.", $tc);
} elsif ($k == 0 || $hoogst[1] == 0) { 
	$im->string(gdSmallFont,  175, 50, "No data for the month ".$maanden[$maand-1]." $jaar.", $tc);
	$error = "No data for this month"; 
}
#als er een error is dan zeggen dat er een fout is en een rare grafiek maken
if ($error) { 
	$im->string(gdSmallFont, 23,  8, "   4.0", $tc);
	$im->string(gdSmallFont, 23, 33, "   3.0", $tc);
	$im->string(gdSmallFont, 23, 58, "   2.0", $tc);
	$im->string(gdSmallFont, 23, 83, "   1.0", $tc);
	$im->stringUp(gdSmallFont, 7, 115, "bytes per day", $tc);
	$im->string(gdSmallFont,  10, 134, "Total Out ".$maanden[$maand-1]." ".$jaar.":", $tc);
	$im->string(gdSmallFont, 180, 134, "0 bytes", $tc);
	$im->string(gdSmallFont,  10, 149, "Expected Out ".$maanden[$maand-1]." ".$jaar.":", $tc);
	$im->string(gdSmallFont, 180, 149, "0 bytes", $tc);
	$im->string(gdSmallFont, 260, 134, "Average ".$maanden[$maand-1]." ".$jaar.":", $avgc);
	$im->string(gdSmallFont, 410, 134, "0 bytes/day", $tc);
	$im->string(gdSmallFont, 260, 149, "Peak ".$maanden[$maand-1]." ".$jaar.":", $tc);
	$im->string(gdSmallFont, 410, 149, "0 bytes", $tc);
	# Text (dagen):
	$x1=96;
	$index=2;
	for ($i=0; $i<$dim-1; $i+=2) {
		$indextemp = $index;
		if (length($index)<2) { $index = " ".$index; };
		$im->string(gdSmallFont, $x1, 117, $index, $tc);
		$x1+=26;
		$index=$indextemp+2;
	};
#alles goed, dus nu gaan we de juiste grafiek maken
} else {
	# find the maxY en define the minY voor in de grafiek
	if ($hoogst[1] > $hoogst[2]) {
		$maximum = $hoogst[1];
	} else {
		$maximum = $hoogst[2];
	}
	$maxY = &formatBytes($maximum,0);
	if ($maxY == 0) { $maxY = 1; }

	#minY is een kwart van maxY
	$minY = $maxY/4;
	
	# y waardes format
	#sprintf("%0.1f",$maxY) is print waarde maxY met 1 decimaal achter de komma
	# dit 4 keer vanwege de 4 waarden
	# de lengte wordt opgevuld tot 6 alleen dat is iets wat VBScript niet kan. Moet dus werken met extra var
	$Yv1 = sprintf("%0.1f",$maxY);
	while(length($Yv1)<6) {
		$Yv1 = " ".$Yv1;
	};
	$Yv2 = sprintf("%0.1f",$minY*3);
	while(length($Yv2)<6) {
		$Yv2 = " ".$Yv2;
	};
	$Yv3 = sprintf("%0.1f",$minY*2);
	while(length($Yv3)<6) {
		$Yv3 = " ".$Yv3;
	};
	$Yv4 = sprintf("%0.1f",$minY);
	while(length($Yv4)<6) {
		$Yv4 = " ".$Yv4;
	};

	# Text (aantal bytes) printen in de image:
	$im->string(gdSmallFont, 23, 8, $Yv1, $tc);
	$im->string(gdSmallFont, 23, 33, $Yv2, $tc);
	$im->string(gdSmallFont, 23, 58, $Yv3, $tc);
	$im->string(gdSmallFont, 23, 83, $Yv4, $tc);
	# Text (links):
	# Dit is de text die links van de Y as komt te staan
	@tmp = split /\s/,&formatBytes($maximum,"2");
	$ytext = $tmp[1];
	$im->stringUp(gdSmallFont, 7, 115, $ytext." per day", $tc);

	# totaal en gemiddelde bepalen
	for $x ( 0 .. $k ) {
		$totin += $data[1][$x];
		$totout += $data[2][$x];
	}
	$avgin = $totin/$k;
	$avgout = $totout/$k;
	$avg = $avgin+$avgout;
	$tot = $totin + $totout;
	
	$Ymax = "17";
	$Ymin = "112";
	# ?? dit is dom maar ok.
	$Diff = $Ymin-$Ymax;
	# $PpG = $Diff/$hoogst[1];
	$ppb = $Diff/$maxY; # pixel per Gigabyte, (c) vincent :) en ik verzon ppb, pixels per byte
	#hier halen we even de dingen uit Kb, B, etc..
	$formaat = substr(&formatBytes($maximum,1),-2);
	#"B", "KB", "MB", "GB", "TB", "PB"
	if     ($formaat eq "PB") { $deelfakt = 1/1024/1024/1024/1024/1024; }
	elsif ($formaat eq "TB") { $deelfakt = 1/1024/1024/1024/1024; }
	elsif ($formaat eq "GB") { $deelfakt = 1/1024/1024/1024; }
	elsif ($formaat eq "MB") { $deelfakt = 1/1024/1024; }
	elsif ($formaat eq "KB") { $deelfakt = 1/1024; }
	else { $deelfakt = 1; };

	#hier bepalen we de y waarde per dag aan de hand van een berekening en slaan we op in een array $perdag[dag]
	for $x ( 0 .. $k) {
		$perdagin[$x] = 112-(($data[1][$x]*$deelfakt)*$ppb);
		$perdagout[$x] = 112-(($data[2][$x]*$deelfakt)*$ppb);
	};
	
	#Het gemiddelde uitrekenen
	$AVGIN = $Ymin-($avgin*$deelfakt*$ppb);
	$AVGOUT = $Ymin-($avgout*$deelfakt*$ppb);
	# Text (dagen):
	$x1=96;
	$index=2;
	#Loopje om 2, 4, 6, ..reeks onder de grafiek te zetten
	for ($i=0; $i<$dim-1; $i+=2) {
		$tmpindex=$index;
		if (length($index)<2) { $index = " ".$index; };
		$im->string(gdSmallFont, $x1, 117, $index, $tc);
		$x1+=26;
		$index=$tmpindex+2;
	};
	
	# Palen:
	#Loopje om de groene balken neer te zetten voor de dagen
	$x1=83;
	for $x ( 0 .. $k ) {
		if ($perdagin[$x]!=112) { $im->filledRectangle( $x1, $perdagin[$x], $x1+5, $Ymin, ($x%2==1?$grc2:$grc)); };
		if ($perdagout[$x]!=112) { $im->filledRectangle( $x1+6, $perdagout[$x], $x1+11, $Ymin, ($x%2==1?$rood2:$rood)); };
		$x1=$x1+13;
	};
	
	# Gemiddelde-lijnen:
	if ($AVGIN<112 && $AVGIN>17) {	$im->line(83, $AVGIN, 484, $AVGIN, $grc);}
	if ($AVGOUT<112 && $AVGOUT>17) { $im->line(83, $AVGOUT, 484, $AVGOUT, $rood);}

	$expthismonthout = &formatBytes($avgout*$dim,1);
	$expthismonthin = &formatBytes($avgin*$dim,1);
	$thismonthin = &formatBytes($totin,1);
	$thismonthout = &formatBytes($totout,1);
	while (length($expthismonth)>length($thismonth)) {
		$thismonth = " ".$thismonth;
	};
	$avg = &formatBytes($avg,1);
	$avgin = &formatBytes($avgin,1);
	$avgout = &formatBytes($avgout,1);
	$peak = &formatBytes($piek[1],1);
	while (length($peak)>length($avg)) {
		$avg = " ".$avg;
	};
	$im->string(gdSmallFont,  10, 134, "Total In/Out:", $tc);
	$im->string(gdSmallFont, 120, 134, $thismonthin."/".$thismonthout, $tc);
	$im->string(gdSmallFont,  10, 149, "Expected In/Out:", $tc);
	$im->string(gdSmallFont, 120, 149, $expthismonthin."/".$expthismonthout, $tc);
	$im->string(gdSmallFont, 230, 134, "Average In/Out per day:", $avgc);
	$im->string(gdSmallFont, 380, 134, $avgin."/".$avgout, $tc);
	$im->string(gdSmallFont, 230, 149, "Peak ".(substr($piek[0],6,1)==0?substr($piek[0],7,1):substr($piek[0],6,2))." ".$maanden[$maand-1]." ".$jaar.":", $tc);
	$im->string(gdSmallFont, 380, 149, $peak."/day", $tc);
};	

# Uitspugen die zooi:
print "Content-type: image/png\n\n";
print $im->png;
# C'est tout
################################
# Even de waarden uit de querystring of formdata halen.
sub parse_form {
   my($buffer,$pair,$value,@pairs,$name);

   read(STDIN, $buffer, $ENV{'CONTENT_LENGTH'});
   if (length($buffer) < 4) {
         $buffer = $ENV{QUERY_STRING};
    }
 
  @pairs = split(/&/, $buffer);
   foreach $pair (@pairs) {
      ($name, $value) = split(/=/, $pair);

      $value =~ tr/+/ /;
      $value =~ s/%([a-fA-F0-9][a-fA-F0-9])/pack("C", hex($1))/eg;

      $FORM{$name} = $value;
   }
}

