/************************************************************\
       Eggdrop MRTG plugin v0.1 by blh <blh@sr-71.nu>

       Compilation: gcc -Wall -O2 -o egglog egglog.c
\************************************************************/

#include <stdio.h>
#include <stdlib.h>
#include <strings.h>
#include <errno.h>

int main(int argc, char **argv)
{
	FILE *fp = NULL;
	FILE *fp2 = NULL;
	char buf[1024];

	int lines = 0;
	int joins = 0;

	fpos_t pos = 0;
	fpos_t prev = 0;

	if(argc < 2)
		fprintf(stderr, "syntax: %s <channel.log>\n\tlog options jp (join/part, public) needed\n", argv[0]), exit(-1);

	if((fp = fopen(argv[1], "r")) == NULL)
		perror("fopen"), exit(-1);

	if((fp2 = fopen(".egglog", "r")) != NULL)
		{
			fgets(buf, 1024, fp2);
			pos = atoi(buf);

			fseeko(fp, prev, SEEK_END);
			fgetpos(fp, &prev);

			if(pos > prev)
				rewind(fp);
			else
				fsetpos(fp, &pos);

			fclose(fp2);
		}
	else
		{
			fseeko(fp, prev, SEEK_END);
			fgetpos(fp, &prev);
			if((fp2 = fopen(".egglog", "w")) != NULL)
				{
					fprintf(fp2, "%d", (int)prev);
					fclose(fp2);
				}
			printf("0\n0\n0 0\n0\n");
			exit(0);
		}

	while((fgets(buf, 1024, fp)) != NULL)
		{
			prev = pos;
			fgetpos(fp, &pos);

			if((!strncmp(buf + 8, "<", 1)))
				lines++;
			else if((strstr(buf, "joined #")) != NULL)
				joins++;
			else if((!strncmp(buf + 8, "Action", 6)))
				lines++;
		}

	printf("%d\n%d\n0 0\n0\n", lines, joins);

	fclose(fp);

	if((fp2 = fopen(".egglog", "w")) != NULL)
		{
			fprintf(fp2, "%d", (int)pos);
			fclose(fp2);
		}
	exit(0);
}
