'======================================
'	Directory Size: returns the number of files/size of a specific folder.
'
'	File: 		directorysize.vbs
'	Author:		Michele Di Maria | michele@nt2.it
'	Version:	1.0
'	Date:		8/24/2013
'	Requires:	Microsoft Windows (TM)
'				Read permissions on the monitored folder
'
'	Usage: directorysize.vbs [path] (int)<offset>
'		[path]: The folder to monitor. Can be a local or remote drive (\\server\share\path).
'		offset: The number of files to add/substract to the result. Can be a positive or negative number.
'
'	Sample use in MRTG: 
'		Title[example]: Number of files
'		Pagetop[example]: <H1>Number of files</H1>
'		MaxBytes[example]: 10000
'		Options[example]: gauge, nopercent, growright
'		Target[example]: `cscript.exe //nologo c:\mrtg\contrib\directorysize\directorysize.vbs "c:\mydata" -1`
'		YLegend[example]: Legend
'		ShortLegend[example]:Files
'		LegendI[example]:Size (MB)
'		LegendO[example]:Files
'		Legend1[example]:Size (MB)
'		Legend2[example]:Files
'======================================
Dim fso,ts
Dim Directory
Dim Result
Dim Offset

'I check the parameters
Set objArgs = WScript.Arguments
If objArgs.Count <> 1 and  objArgs.Count <> 2 Then 
	Wscript.Echo "Syntax: directorysize.vbs [path] (int)offset"
	WScript.Quit -1
End If
'I initialize the parameters
Directory = objArgs(0)
Offset = 0 
If objArgs.Count = 2 Then
	Offset = objArgs(1)
End IF
'I get the results
Set fso = CreateObject("Scripting.FileSystemObject") 
set dir = fso.getfolder(Directory)
Result = dir.Files.Count
If Result > 0 Then
	Result = Result + Offset
End If
'I return the results
WScript.Echo FormatNumber(dir.Size / 1024 / 1024, 1, -1)
WScript.Echo Result
WScript.Echo ""
WScript.Echo Directory