'Backup Exec Log Reader
'(c)2002 352 Media Group ( http://www.352media.com )
'by Merlyn Oppenheim ( merlyn@352media.com )

option explicit


'path to backup server
'example: const BackupPath="c:\progra~1\seagat~1\backup~1\nt\data"
const BackupPath="\\servername\c$\progra~1\seagat~1\backup~1\nt\data"

'fill in the Job Name of the backup you wish to monitor
const JobName="Master Backup"


dim fso


dim match,matches,ffile,line

dim jobregex,eqline,processed,compressed,dline,backedup

set jobregex=newregex("^Job (\w+): (.*)$")
set eqline=newregex("^=+$\n")
set dline=newregex("^-+$\n")
set processed=newregex("Processed ([\d,]+) bytes")
set compressed=newregex("Software compression ratio: ([\d\.]+):1")
set backedup=newregex("^Backed up ")


set fso=createobject("scripting.filesystemobject")
'set ffile=fso.opentextfile("c:\work\backupexeclog.txt")

dim fileregex,thisfile
set fileregex=newregex("^bex\d+\.txt$")
fileregex.ignorecase=true


dim folder,newestfile,lastdate,lastfile
lastdate=cdate("january 01, 1980")
set folder=fso.getfolder(BackupPath)

dim jobproperties
set jobproperties=createobject("scripting.dictionary")
for each ffile in folder.files
	if fileregex.test(ffile.name) then
		if ffile.DateCreated>lastdate then
			set thisfile=ffile.openastextstream
			jobproperties.removeall
			readproperties jobproperties,thisfile

			if jobproperties("name")=JobName then
				lastdate=ffile.DateCreated
				lastfile=ffile.name

			end if
			thisfile.close
'		wscript.echo ffile.name & ffile.DateCreated
		end if

	end if
next


'wscript.echo lastdate
'wscript.echo lastfile


set thisfile=fso.opentextfile(BackupPath & "\" & lastfile)

readproperties jobproperties,thisfile
writetotal thisfile

thisfile.close
dim uncompressedtotal,uncompressed

sub writetotal(ffile)
	dim compressionratio,total,erroroccured
	total=0
	do
		line= readtill(ffile,backedup)

		if not isnull(line) then
			line=readtill(ffile,processed)


			if isnull(line) then
				erroroccured="processed not found"
			else
				set matches=processed.execute(line)
				uncompressed=cdbl(replace(matches(0).submatches(0),",",""))
				uncompressedtotal=uncompressedtotal+cdbl(replace(matches(0).submatches(0),",",""))
				'wscript.echo line
			end if
		end if

		if not isnull(line) then
			line=readtill(ffile,compressed)

			if isnull(line) then
				erroroccured="compressed not found"
			else
				set matches=compressed.execute(line)

				total=total+uncompressed/cdbl(matches(0).submatches(0))
				'wscript.echo line
			end if
		end if
	loop while not isnull(line)

	if erroroccured<>"" then
		'wscript.echo erroroccured
		wscript.echo 0
		wscript.echo 0
		wscript.echo 0
	'	wscript.echo "" 'cscript adds a crlf for us
	else
		wscript.echo clng(total/1048576)
		wscript.echo clng(uncompressedtotal/1048576)
		wscript.echo 0 'no uptime
	'	wscript.echo "" 'cscript adds a crlf for us

	end if
end sub

function dumpproperties
	dim key
	for each key in jobproperties
		wscript.echo jobproperties(key)
	next
end function



sub readproperties(jobproperties,ffile)
	jobproperties.removeall
	line=ffile.readline  'read the first line
	dim line

	do while not ffile.AtEndOfStream
		line=ffile.readline


		set matches=jobregex.execute(line)
		for each match in matches
			if not jobproperties.exists(match.value) then
				jobproperties.add match.submatches(0),match.submatches(1)
			end if
		next

		if matches.count=0 then exit do

	loop
end sub



function readtill(ffile,regex)
	'wscript.echo "readtill"
	dim line
	do while not ffile.AtEndOfStream
	'	wscript.echo line
		line=ffile.readline
		if regex.test(line) then exit do
	loop
	if ffile.AtEndOfStream then
		readtill=null
	else
		readtill=line
	end if

end function


function newregex(n)
	set newregex=new regexp
	newregex.pattern=n
end function