#!/usr/bin/perl -w

# please use
# 	SAA_delete.pl -man
# to view the manpage of this script

##################################################################
#           PLEASE MODIFY THE FOLLOWING TO INSTALL               #
# point the path below to the location of the RttMon* libs
use lib qw(/usr/local/SAA/lib /usr/local/SNMP/lib);
#                PLEASE DO NOT MODIFY AFTER THIS                 #
##################################################################

use ciscoRttMonLib "0.2";
&ciscoRttMonLib::delete();

=head1 NAME

SAA_delete.pl - delete SAA entry from a Cisco IOS device

=head1 SYNOPSIS

B<>SAA_delete.pl -configfile I<filename> [-debug] 

B<>SAA_delete.pl -ioshost I<IOSdevice> -community I<SNMPcommunity> -entry I<ProbeNumber> [-debug] 

SAA_delete.pl -man

=head1 DESCRIPTION

Please read the fetchstart.pl manual page first.

SAA_delete deletes a SAA probe entry from the Cisco IOS device.

Command line arguments are:

=over 1

=item -configfile I<filename> 

The SAA probe configuration file.

=item -ioshost I<IOSdevice>

The IP address / DNS name of the IOS device.

=item -community I<SNMPcommunity>

The SNMP community string, which will be used to read/write access the ciscoRttMon MIB

=item -entry I<ProbeNumber>

The entry number on the IOS device (1..2147483647).

=item -debug

Prints all measured / calculated values and verbose errors.

=head1 AUTHOR

Joerg.Kummer at Roche.com 

=cut

