#!/usr/bin/perl

# reads stats and uptime from SNMP variables for mrtg

use SNMP_util 0.86, qw/snmpget snmpQueue_MIB_File/;

%DEFAULTS = (
    '-squidHost' => 'public@localhost:3401',
    '-squidMib'  => '/usr/local/etc/squid/mib.txt',
    '-p1'        => 'cacheHttpOutKb',
    '-p2'        => 'cacheHttpInKb',
    '-p3'        => 'cacheUptime',
    '-p4'        => 'cacheSoftware cacheVersionId',
);

$target   = ($DEFAULTS{$ARGV[0] or '-squidHost'} or $ARGV[0] or '127.0.0.1');
$add_mib  = ($DEFAULTS{$ARGV[1] or '-squidMib'}  or $ARGV[1] or '-'        );
$query[0] = ($DEFAULTS{$ARGV[2] or '-p1'}        or $ARGV[2] or '-'        );
$query[1] = ($DEFAULTS{$ARGV[3] or '-p2'}        or $ARGV[3] or '-'        );
$query[2] = ($DEFAULTS{$ARGV[4] or '-p3'}        or $ARGV[4] or '-'        );
$query[3] = ($DEFAULTS{$ARGV[5] or '-p4'}        or $ARGV[5] or '-'        );

snmpQueue_MIB_File($add_mib) unless $add_mib eq '-';

undef $result; for (0..3) {

    $query = ('0', '0', '', '')[$_];
    $query = (join ' ', snmpget($target, split /\s+/,$query[$_]) or $query)
        unless $query[$_] eq '-';

    $result .= "$query\n"
}

print $result;
