#!/bin/sh
# $Id: t-smar-0.sh,v 1.24 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# simple DNS MX+A lookup tests by contacting SMAR
# uses t-smar-1 and startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

if test X"${SM_NO_DNS_TEST}" != "X"
then
  echo "SKIPPED: $0"
  exit 0
fi

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=smar-0.out
IP=smar-0.ip
OK=smar-0.ok
TPRG=./t-smar-1
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

rm -f ${SOCK} ${PIDS}

# prepare mailertable for MX cutoff check
${CAT} > ${MT} <<EOF
host20.sm9.org	lmtp:
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh || exit 1

rm -f ${OUT} ${IP} ${OK}

TEST=1
# ----------------------------------------
# test MX lookups for two known domains
${VALGRIND} ${TPRG} -M -VVVV '<a@smX.esmtp.org>' '<b@smX.sm9.org>' > ${OUT} 2>&1

#mine.esmtp.org:
#IP[0]=134.245.248.42 [86f5f82a]

grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=10.1.2.3 [a010203]
IP[0]=10.1.2.4 [a010204]
IP[1]=10.1.2.5 [a010205]
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

rm -f ${OUT} ${IP} ${OK}

TEST=2
# ----------------------------------------
# test MX lookups with mixed case domain names
${VALGRIND} ${TPRG} -M -VVVV '<a@Esmtp.Org>' '<a@ESmtP.ORG>' > ${OUT} 2>&1
grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=63.195.85.27 [3fc3551b]
IP[0]=63.195.85.27 [3fc3551b]
EOF
if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi
rm -f ${OUT} ${IP} ${OK}


TEST=3
# ----------------------------------------
# test MX cutoff:
# list1.sm9.org.  MX      10 server.sm9.org.
# list1.sm9.org.  MX      20 host20.sm9.org.
# list1.sm9.org.  MX      30 localhost.sm9.org.
# host20.sm9.org is considered "local" due to mailertable entry
# hence only the first IP address is returned
${VALGRIND} ${TPRG} -VVVV '<a@list1.sm9.org>' > ${OUT} 2>&1

grep '^IP' ${OUT} | sort > ${IP}
cat > ${OK} <<EOF
IP[0]=63.195.85.27 [3fc3551b]
EOF

if diff ${OK} ${IP}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
fi

#rm -f ${OUT} ${IP} ${OK}

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi

exit ${ERRS}
