#!/bin/sh
# $Id: t-prot-1.sh,v 1.2 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to "protected recipients" with "wildcard" matching
# Uses t-acc-0, aliases and access map, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=prot-1.out
RES=prot-1.addr
OK=prot-1.ok
TPRG=./t-acc-0
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# create map for smar
rm -f ${ALIMAP}
cat > ${ALI} <<EOF
user:	local:
user2:	local:
list1:	<user1-1@l1-1.dom> <user2-1@l1-1.dom> <list2@local.dom>
list2:	<user1-2@l2-1.dom> <user2-2@l2-2.dom>
list3:	<user1-3@l3-1.dom> <user2-3@l3-2.dom>
EOF
${MM} < ${ALI}
if test $? -ne 0
then
  echo "$0: t-mm failed"
  exit 1
fi

rm -f ${ACCMAP}
# create access map for tests
cat > ${ACC} <<EOF
protectedrcpt:list1@b.c	list:<list1@b.c>
protectedrcpt:list2	list:<list2@b.c>
protectedrcpt:list3	from:<moderator3@local.dom> cltaddr:1.2.3.4 cltaddr:10
protectedrcpt:list4	bogus:entry
protectedrcpt:user2	from:<>
EOF
${VALGRIND} ${MM} -t'	' -F ${ACCMAP} < ${ACC}

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
EOF

TEST=1
# ----------------------------------------
# sender not allowed
${VALGRIND} ${TPRG} -VV -p '<user1-1+x@l1-1.dom>' '<list1@b.c>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=550
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
# sender allowed
${VALGRIND} ${TPRG} -p '<user1-1@l1-1.dom>' -mD '<list1@b.c>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
# sender allowed
${VALGRIND} ${TPRG} -p '<moderator3+x@local.dom>' -mD '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=4
# ----------------------------------------
# sender not allowed
${VALGRIND} ${TPRG} -p '<moderator3+x@local.dom>' '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=550
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=5
# ----------------------------------------
# client allowed
${VALGRIND} ${TPRG} -p '<>' -i 1.2.3.4 '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=6
# ----------------------------------------
# client not allowed
${VALGRIND} ${TPRG} -p '<>' -i 1.2.3.5 '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=550
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=7
# ----------------------------------------
# client allowed
${VALGRIND} ${TPRG} -p '<>' -i 10.2.3.4 -mD '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=8
# ----------------------------------------
# client not allowed
${VALGRIND} ${TPRG} -p '<>' -i 11.2.3.4 -mD '<list3@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=550
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=9
# ----------------------------------------
# sender not allowed
${VALGRIND} ${TPRG} -p '<moderator3@local.dom>' '<user2@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=550
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=10
# ----------------------------------------
# sender allowed
${VALGRIND} ${TPRG} -p '<>' -mD '<user2@local.dom>' > ${OUT} || ERRS=`expr ${ERRS} + 1 `
cat > ${OK} <<EOF
ara_status=0
EOF
if diff ${OK} ${OUT}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


rm -f ${OUT} ${RES} ${OK}

exit ${ERRS}
