#!/bin/sh
# $Id: t-owner-2.sh,v 1.7 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion for RFC2821 addresses with owner-.
# for remote addresses.
# Uses smar, t-smar-1, "aliases" map, t-mm, startsmar.sh
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=alias-3.out
RES=alias-3.ip
GEN=alias-3.gen
OK=alias-3.ok
TPRG=./t-smar-1
ALIAS=alias-3

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
some.dom	[127.1.2.3]
other.dom	[3.4.5.6]
some.dom	[7.8.9.10]
remote.dom	[11.12.13.14]
EOF

# create map for smar
rm -f ${ALIMAP}
cat > ${ALIAS} <<EOF
listone:     <listone-user1@local.dom>
owner-listone:     ownerlistone
listoneerr:     <listoneerr-user1@nosuch.dom>
owner-listoneerr:     ownerlistoneerr
list0:     <list0-user1@local.dom> <list1@local.dom> <list0-user2@some.dom>
owner-list0:     ownerlist0
owner-list1:     ownerlist1
list1:     <list1-user1@remote.dom> <list1-user2@some.dom>
owner-list2@some.dom:     <ownerlist2somedom@some.dom>
list2@some.dom:     <list0@local.dom> <list1@local.dom> <list2-user0@some.dom>
list1err:     <list1err-user1@nosuch.dom> <list1-user2@some.dom>
owner-list1err:     ownerlist1err
ok:	ok
postmaster:     ok
EOF

${MM} < ${ALIAS}
if test $? -ne 0
then
  echo "$0: t-mm failed"
  exit 1
fi

# start SMAR
SMAROPT="-A 4" ${SHELL} ${SD}/startsmar.sh || exit 1
rm -f ${OUT} ${RES} ${OK}

# Problem: the output isn't ordered (asynchronous operation, and
# hash table to list conversion).

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -O -VVV -o -A '<list2@some.dom>' > ${OUT} 2>&1 || ERRS=`expr ${ERRS} + 1 `
egrep '^(aliased|owner)' ${OUT} | sort > ${RES}
sort > ${OK} <<EOF
owners=3
owner=<owner-list0@local.dom>, idx=2
owner=<owner-list1@local.dom>, idx=4
owner=<owner-list2@some.dom>, idx=1
aliased=<list1-user1@remote.dom>:IP[0]=11.12.13.14 [b0c0d0e]:pref[0]=0:ttl[0]=3600:owner_idx=4:
aliased=<list2-user0@some.dom>:IP[0]=7.8.9.10 [708090a]:pref[0]=0:ttl[0]=3600:owner_idx=1:
aliased=<list1-user2@some.dom>:IP[0]=7.8.9.10 [708090a]:pref[0]=0:ttl[0]=3600:owner_idx=4:
aliased=<list0-user1@local.dom>:IP[0]=${SM_LMTPIPV4D} [${SM_LMTPIPV4H}]:pref[0]=0:ttl[0]=3600:owner_idx=2:
aliased=<list0-user2@some.dom>:IP[0]=7.8.9.10 [708090a]:pref[0]=0:ttl[0]=3600:owner_idx=2:
EOF
if diff -w ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}

exit ${ERRS}
