#!/bin/sh
# $Id: t-owner-0.sh,v 1.16 2005/10/05 23:17:47 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test alias expansion including owner- for RFC2821 addresses.
# Uses t-rcpt-0, "aliases" map, t-mm
# ------------------------------------------------------------
#
test -s stop && exit 1
#

# path to programs
P=..
SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=owner-0.out
RES=owner-0.addr
OK=owner-0.ok
TPRG="./t-rcpts-0 -o"
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# create map for smar
rm -f ${ALIMAP}
${MM} <<EOF
listone:     <listone-user1@local.dom>
owner-listone:     ownerlistone
listoneerr:     <listoneerr-user1@nosuch.dom>
owner-listoneerr:     ownerlistoneerr
list0:     <list0-user1@local.dom> <list1@local.dom> <list0-user2@some.dom>
owner-list0:     ownerlist0
owner-list1:     ownerlist1
list1:     <list1-user1@remote.dom> <list1-user2@some.dom>
owner-list2@some.dom:     <ownerlist2somedom@some.dom>
list2@some.dom:     <list0@local.dom> <list1@local.dom> <list2-user0@some.dom>
list1err:     <list1err-user1@nosuch.dom> <list1-user2@some.dom>
owner-list1err:     ownerlist1err
ok:	ok
postmaster:     ok
EOF
if test $? -ne 0
then
  echo "$0: t-mm failed"
  exit 1
fi

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
b.c	lmtp:
some.dom	[127.1.2.3]
EOF

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV -l -F '<listone@local.dom>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
egrep '^(address|owner):' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address: <listone-user1@local.dom> idx: 2, owner: 1,
owner: <owner-listone@local.dom> idx: 1, owner: 0,
EOF
if diff -w ${OK} ${OUT}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV -l -F '<list1@local.dom>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
egrep '^(address|owner):' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address: <list1-user1@remote.dom> idx: 2, owner: 1,
address: <list1-user2@some.dom> idx: 3, owner: 1,
owner: <owner-list1@local.dom> idx: 1, owner: 0,
EOF
if diff -w ${OK} ${OUT}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV -l '<list0@local.dom>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
egrep '^(address|owner):' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address: <list0-user1@local.dom> idx: 2, owner: 1, flags: 2002000
address: <list0-user2@some.dom> idx: 6, owner: 1, flags: 2002000
address: <list1-user1@remote.dom> idx: 4, owner: 3, flags: 2002000
address: <list1-user2@some.dom> idx: 5, owner: 3, flags: 2002000
owner: <owner-list0@local.dom> idx: 1, owner: 0, flags: 5020200
owner: <owner-list1@local.dom> idx: 3, owner: 1, flags: 7020200
EOF
if diff -w ${OK} ${OUT}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV -l -r -F '<list2@some.dom>' > ${RES} || ERRS=`expr ${ERRS} + 1 `
egrep '^(address|owner):' ${RES} | sort > ${OUT}
cat > ${OK} <<EOF
address: <list0-user1@local.dom> idx: 3, owner: 2,
address: <list0-user2@some.dom> idx: 7, owner: 2,
address: <list1-user1@remote.dom> idx: 5, owner: 4,
address: <list1-user2@some.dom> idx: 6, owner: 4,
address: <list2-user0@some.dom> idx: 8, owner: 1,
owner: <owner-list0@local.dom> idx: 2, owner: 1,
owner: <owner-list1@local.dom> idx: 4, owner: 2,
owner: <owner-list2@some.dom> idx: 1, owner: 0,
EOF
if diff -w ${OK} ${OUT}
then
  ${VERBOSE} && echo "$0: test ${TEST} OK"
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && exit ${ERRS}
fi


exit ${ERRS}
