#!/bin/sh
# $Id: t-lum-0.sh,v 1.6 2005/07/05 17:20:04 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Script to test local user map for RFC2821 addresses.
# Uses smar, t-smar-2, aliases and "local user" map, t-mm, startsmar.sh
# and t-hostname
# ------------------------------------------------------------
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

OUT=lum-2.out
RES=lum-2.ip
OK=lum-2.ok
TPRG=./t-smar-2
LU=users
LUM=${LU}.db
CONF=lum.conf
VERBOSE=false

if test X"`uname`" != "XOSF1"
then
while getopts s:V FLAG
do
  case "${FLAG}" in
    s) SKIP="${SKIP} ${OPTARG}";;
    V) VERBOSE=true;;
  esac
done
shift `expr ${OPTIND} - 1`
fi

# Note: reference to t-hostname! XREF
HOSTNAME=`../libmta/t-hostname -l -V 2>/dev/null`
if test $? -ne 0
then
  echo "t-hostname failed"
  exit 1
fi
if test X"${HOSTNAME}" = X
then
  echo "t-hostname returned empty name"
  exit 1
fi
if echo X"${HOSTNAME}" | grep '\.' >/dev/null
then
  :
else
  echo "t-hostname returned bogus name ${HOSTNAME}"
  exit 1
fi

killit()
{
if test -s ${PIDS}
then
  # stop MTA components
  for i in `cat ${PIDS}`
  do
    kill ${i}
  done
fi
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
#rm -f ${MTMAP}
exit 1
}

# create map for smar
rm -f ${ALIMAP} ${LUM}
${MM} -F ${LUM} <<EOF
user1:	ok
user2:	rhs
user3:	something
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

# create map for smar
${MM} <<EOF
postmaster:	user1
EOF
if test $? -ne 0
then
  echo t-mm failed
  exit 1
fi

cat > ${CONF} <<EOF
smar {
 map lum { type=hash; file=${LUM}; }
 local_user_map { name=lum; flags=implicitly_match_detail; }
}
EOF

rm -f ${SOCK} ${PIDS}
trap killit 1 2 3

# create mailertable (save old version?)
${CAT} > ${MT} <<EOF
local.dom	lmtp:
${HOSTNAME}	lmtp:
EOF

# start SMAR
${SHELL} ${SD}/startsmar.sh -f ${CONF} || exit 1
rm -f ${OUT} ${RES} ${OK}

TEST=1
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user1@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=2
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user1+@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=3
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user1+ext1@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=${SMAR_DFLT_RES}
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

TEST=4
# ----------------------------------------
${VALGRIND} ${TPRG} -VVV '<user1*@local.dom>' > ${OUT} 2>&1
grep '^status=' ${OUT} > ${RES}
cat > ${OK} <<EOF
status=550
EOF
if diff ${OK} ${RES}
then
  :
else
  ERRS=`expr ${ERRS} + 1 `
  echo "$0: test ${TEST} failed."
  test X"${SM_STOPONERROR}" != X && killit
fi

# ----------------------------------------

# stop SMAR
for i in `cat ${PIDS}`
do
  kill ${i}
done
# ----------------
# thanks kids for not following the POSIX standard...
if test X"`uname`" = "XLinux"
then
  killall smar
fi
rm -f ${MTMAP}

exit ${ERRS}
