#!/bin/sh
# ${Id}: startsmar.sh,v 1.23 2004/09/28 19:59:37 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# start smar (used by other test scripts)
# ------------------------------------------------------------
# Note: make sure this script is invoked via ksh on OSF/1.
#
test -s stop && exit 1
#

SD=`dirname $0`
if test "${SD}" = "."
then
   SD=../smar
fi
. ${SD}/common.sh

NOMT=false
GETNS=${SD}/../misc/getns.sh
if test -x ${GETNS}
then
  . ${GETNS}
else
NS=`grep '^nameserver' /etc/resolv.conf | head -1 | sed -e 's/nameserver[	 ]*\([0-9][0-9\.]*\).*$/\1/'`
fi
if test -z "${NS}"
then
  echo "$0: no nameserver found"
  exit 0
fi

while getopts f:mo: FLAG
do
  case "${FLAG}" in
    m) NOMT=true;;
    f) SMAROPTS="-f ${OPTARG} ${SMAROPTS}";;
    o) SMAROPTS="${OPTARG} ${SMAROPTS}";;
  esac
done
shift `expr ${OPTIND} - 1`

SMARTMOUT=${SM_DNS_TIMEOUT:-16}

# path to programs
P=..
D=qmsmar
SOCK=${D}/qmsmar
PIDS=pids
test -d ${D} || mkdir ${D}
if test -f ${MT} -o "${NOMT}" = "true"
then
  :
else
${CAT} > ${MT} <<EOF
local.host	[127.0.0.1]
local.dom	lmtp:
EOF
rm -f ${MTMAPDB}
${MM} -t'	' -F ${MTMAPDB} < ${MT}
fi

# start SMAR in background
${P}/smar/smar ${SMAROPT} ${SMAROPTS} -H 0 -O ${SMARTMOUT} -i ${NS} $@ > a.log 2>&1 &
echo $! > ${PIDS}
i=1
while test ! -r ${SOCK}
do
  sleep 1
  i=`expr ${i} + 1`
  if test ${i} -ge 15
  then
    exit 1
  fi
done
sleep 1
exit 0
