/*
 * Copyright (c) 2002-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qm_to_sc.c,v 1.24 2005/08/22 18:16:20 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/io.h"
#include "sm/rcb.h"
#include "sm/qmgr.h"
#include "sm/qmgr-int.h"
#include "sm/rcbcomm.h"
#include "qmgr.h"
#include "log.h"

/*
**  QM_TO_SC -- QMGR to SMTPC interface
**	Invoked on writability by sm_qmgr_smtpc() which runs as a task.
**
**	Parameters:
**		tsk -- evthr task
**
**	Returns:
**		Success: evthread action code
**		Error: usual sm_error code
**
**	Last code review: 2003-10-17 03:23:14
*/

sm_ret_T
qm_to_sc(sm_evthr_task_P tsk)
{
	sm_ret_T ret;
	qsc_ctx_P qsc_ctx;

	SM_IS_EVTHR_TSK(tsk);
	qsc_ctx = (qsc_ctx_P) tsk->evthr_t_actx;
	SM_IS_QSC_CTX(qsc_ctx);

	/*
	**  If the RCB is correctly sent to a DA then the AQR_FL_WAIT4UPD
	**  flag should be set for each recipient. However, this isn't simple:
	**  this function would have to unpack the RCB to find the
	**  recipient ids and look them up to actually lock and change
	**  the recipient flags.
	**  Use the (new) callback for RCB entries (see sm/rcbl.h) to update
	**  the recipient status and use the DA transaction link in aq_rcpt
	**  to find all recipients that are being sent to SMTPC. The callback
	**  receives aq_ctx and one aq_rcpt as context (aq_rsnd_ctx_P).
	*/

	ret = sm_rcbcom2mod(tsk, &(qsc_ctx->qsc_com));
	if (sm_is_err(ret))
	{
		qmgr_ctx_P qmgr_ctx;

		qmgr_ctx = qsc_ctx->qsc_qmgr_ctx;
		SM_IS_QMGR_CTX(qmgr_ctx);
		sm_log_write(qmgr_ctx->qmgr_lctx,
			QM_LCAT_SMTPC, QM_LMOD_TO_SMTPC,
			SM_LOG_ERROR, 8,
			"sev=ERROR, func=qm_to_sc, sm_rcbcom2mod=%m", ret);
	}
	return ret;
}
