/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: log2time.c,v 1.3 2005/08/30 00:08:45 ca Exp $")

#include "sm/stdio.h"
#include "sm/time.h"
#include "sm/sysexits.h"

/*
**  Convert logging timestamp into seconds since the epoch.
*/

static void
log2time(FILE *fp, const char *format, bool full)
{
	char *s;
	time_t t;
	char line[256];
	struct tm tms;

	while (fgets(line, sizeof(line), fp) != NULL)
	{
		s = strptime(line, format, &tms);
		if (s != NULL)
		{
			t = mktime(&tms);
			fprintf(stdout, "%ld%s", (long) t, full ? s : "\n");
		}
	}
}

static void
usage(const char *prg)
{
	fprintf(stderr, "usage: %s [options]\n"
		"Convert logging timestamps to second since the epch\n"
		"Options:\n"
		"-f         show rest of line\n"
		"-F format  format of timestamp\n"
		, prg);
	exit(EX_USAGE);
}

int
main(int argc, char *argv[])
{
	int r;
	bool full;
	char *prg, *format;

	prg = argv[0];
	full = false;
	format = "[%Y-%m-%d/%H:%M:%S]";
	while ((r = getopt(argc, argv, "F:f")) != -1)
	{
		switch (r)
		{
		  case 'F':
			format = strdup(optarg);
			if (format == NULL)
				return(EX_OSERR);
			break;
		  case 'f':
			full = true;
			break;
		  default:
			usage(prg);

			/* NOTREACHED */
			break;
		}
	}
	argc -= optind;
	argv += optind;
	log2time(stdin, format, full);
	return 0;
}
