#!/bin/sh
# $Id: t-pass-hup-0.sh,v 1.6 2005/07/21 22:07:40 ca Exp $
# Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test HUP functionality of mcp to bind again to a port and pass it
# to a service.
# ----------------------------------------

test -s stop && exit 1

ERRS=0
OUT=mcp.out
RPLY=clt.out
PIDS=pids
CONF=mcp.conf1
SOCK="127.0.0.1"
PORT=1357
SOCKET=passfd
VERBOSE=false
PRG=../statethreads/examples/smtps2
SD=`dirname $0`

if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

if test ! -x $PRG
then
  echo $0: missing $PRG
  exit 1
fi

rm -f ${PIDS} ${OUT} ${RPLY}

cat > ${CONF} <<EOF
smtps2 {
	start_action = pass;
	listen_socket { type=inet;port = ${PORT};}
	pass_fd_socket = ${SOCKET};
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = "${PRG}";
	arguments = "smtps2 -l . -i -O ${SOCKET} -d 2";
}
EOF

./mcp -t -d ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}

sleep 3

# connect to inout
../misc/t-unixcl -r -p ${PORT} ${SOCK} >${RPLY} 2>/dev/null <<EOF
QUITz
EOF
ST=$?

# restart
for i in `cat ${PIDS}`
do
  kill -HUP ${i}
done

# connect to inout
../misc/t-unixcl -r -p ${PORT} ${SOCK} >${RPLY} 2>/dev/null <<EOF
QUITz
EOF
ST=$?


for i in `cat ${PIDS}`
do
  kill ${i}
done
exit ${ERRS}
