/*
 * Copyright (c) 2004 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-exit.c,v 1.1 2004/04/26 17:39:11 ca Exp $")

#include "sm/ctype.h"
#include "sm/sysexits.h"
#include "sm/error.h"

#include <stdio.h>

#define EXIT_CODE	EX_USAGE
#define SLEEPT	6

static int Verbose = 0;

#include "rdwrcounter.c"

static void
usage(char *prg)
{
	fprintf(stderr,
		"usage: %s [options]\n"
		"options:\n"
		"-e n:       use n as exit code [%d]\n"
		"-f name:    increment counter in file name\n"
		"-s n:       sleep n seconds before exiting [%d]\n"
		"-V:         increase verbosity\n"
		, prg, EXIT_CODE, SLEEPT);
	exit(EX_USAGE);
}

int
main(int argc, char *argv[])
{
	int c, exit_code, sleept, cur;
	char *cntfn, *prg;

	prg = argv[0];
	cntfn = NULL;
	sleept = SLEEPT;
	exit_code = EXIT_CODE;
	while ((c = getopt(argc, argv, "e:f:s:V")) != -1)
	{
		switch (c)
		{
		  case 'f':
			cntfn = optarg;
			break;
		  case 'e':
			exit_code = atoi(optarg);
			break;
		  case 's':
			sleept = atoi(optarg);
			break;
		  case 'V':
			++Verbose;
			break;
		  case 'h':
		  case '?':
		  default:
			usage(prg);
			break;
		}
	}
	if (cntfn != NULL)
	{
		c = rdwrcounter(prg, cntfn, &cur);
		if (c != 0)
			return c;
	}
	sleep(sleept);
	exit(exit_code);
}
