#!/bin/sh
# $Id: t-exit-1.sh,v 1.8 2005/07/18 17:01:42 ca Exp $
# Copyright (c) 2004 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ----------------------------------------
# test restart: restart program up to maxfails (4)
# Note: 4 (maxfails) and 69 (EX_UNAVAILABLE) are hardcoded in this script
# ----------------------------------------
#
test -s stop && exit 1
#
# set for verbose mode to -V...
V=""
ERRS=0
OUT=mcp.out
PIDS=pids
CONF=exit.conf
CNTF=exit.cnt
VERBOSE=false
SD=`dirname $0`
. ${SD}/../check2/user.sh
if test $# -ge 1
then
  if test "X"$1 = "X-v"
  then
    VERBOSE=true;
  fi
fi

rm -f ${PIDS} ${OUT} ${CNTF}
echo 0 > ${CNTF}
#exit	 _ _ _ _ _ wait	_ 1 1 ${USER} _	./t-exit t-exit -f ${CNTF} -s 1 -e 69
cat > ${CONF} <<EOF
exit {
	start_action = wait;
	min_processes = 1;
	max_processes = 1;
	user = ${USER};
	path = ./t-exit;
	arguments = "t-exit -f ${CNTF} -s 1 -e 69";
}
EOF
./mcp -t -dddd ${CONF} > ${OUT} 2>&1 &
echo $! >> ${PIDS}
sleep 10
CNT=4
if test -s ${CNTF}
then
  C=`cat ${CNTF}`
  if test ${C} -ne ${CNT}
  then
    ${VERBOSE} && echo "counter ${F} wrong: got ${C}, expected ${CNT}"
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  ${VERBOSE} && echo "missing ${CNTF}"
  ERRS=`expr ${ERRS} + 1 `
fi

for i in `cat ${PIDS}`
do
  kill ${i}
done

exit ${ERRS}
