#!/bin/sh
# $Id: t-map-reopen-0.sh,v 1.7 2005/08/16 18:07:38 ca Exp $
# Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# test map reopen
# uses t-map-reopenr-0
# ------------------------------------------------------------
#
test -s stop && exit 1
#

BDBIN="bdbr0"
BDB="bdbr0.db"
BDBINR="bdbrr0"
BDBR="bdbrr0.db"
ERRS=0
P=./t-map-reopenr-0

cat > ${BDBIN} <<EOF
left1:right1
left2:right2
EOF

cat > ${BDBINR} <<EOF
left1:reopen1
left2:reopen2
EOF

# create map
rm -f ${BDB}
./t-mm -t':' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi
rm -f ${BDBR}
./t-mm -t':' -F ${BDBR} < ${BDBINR}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

${P}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `

else

# create maps again
rm -f ${BDB}
./t-mm -t':' -F ${BDB} < ${BDBIN}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi
rm -f ${BDBR}
./t-mm -t':' -F ${BDBR} < ${BDBINR}
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

# test failure mode
${P} -f
if test $? != 0
then
  ERRS=`expr ${ERRS} + 1 `
fi

fi

exit ${ERRS}
