/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: mapscreate.c,v 1.6 2005/06/27 06:04:05 ca Exp $")

#include "sm/assert.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/heap.h"
#include "map.h"
#include "sm/map.h"
#include "sm/maps.h"
#include "sm/mapc.h"
#include "sm/mapclasses.h"
#include "sm/stat.h"

/*
**  MAPS_CREATE - create all known maps
**
**	Parameters:
**		maps -- map system context
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_maps_create(sm_maps_P maps)
{
	sm_ret_T ret;

	ret = sm_bdb_class_create(maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_bht_class_create(maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_passwd_class_create(maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_sockmap_class_create(maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_seq_class_create(maps);
	if (sm_is_err(ret))
		goto error;
	ret = sm_strmap_class_create(maps);
	if (sm_is_err(ret))
		goto error;

	return ret;

  error:
	/* cleanup? */
	return ret;
}
