/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 *	$Id: map.h,v 1.10 2005/06/16 00:39:07 ca Exp $
 */

#ifndef MAP_H
#define MAP_H 1

#include "sm/generic.h"
#include "sm/types.h"
#include "sm/magic.h"
#include "sm/cstr.h"
#include "sm/str-int.h"
#include "sm/time.h"
#include "sm/map-str.h"

union sm_map_optv_U
{
	uint		 sm_mov_int;
	void		*sm_mov_ptr;
};
typedef union sm_map_optv_U sm_map_optv_T;

struct sm_map_opt_S
{
	uint		 sm_map_opt_type;
	sm_map_optv_T	 sm_map_opt_val;
};
#define sm_map_opt_int sm_map_opt_val.sm_mov_int
#define sm_map_opt_ptr sm_map_opt_val.sm_mov_ptr

/* XXX HACK: maximum number of options ... should be an allocated array */
#define SM_MAP_MAX_OPT	8

struct sm_map_S
{
#if SM_MAP_CHECK
	sm_magic_T	 sm_magic;
#endif
	sm_cstr_P	 sm_map_name;
	sm_cstr_P	 sm_map_type;
	sm_mapc_P	 sm_map_class;
	const char	*sm_map_path;
	uint32_t	 sm_map_flags;
	uint32_t	 sm_map_openflags; /* flags when open() was called */
	uint32_t	 sm_map_caps;	/* capabilities */
	int		 sm_map_mode;
	time_T		 sm_map_mtime;
	ino_t		 sm_map_ino;
	void		*sm_map_db;	/* for use by map implementation */

	/* array of option types and option values */
	sm_map_opt_T	 sm_map_opts[SM_MAP_MAX_OPT];

#if SM_USE_PTHREADS
	pthread_rwlock_t	 sm_map_rwlock;
#endif
#if 0
	void			*sm_map_app_ctx; /* for alloc()/free() fcts */
	sm_map_key_alloc_F	 sm_map_key_allocf;
	sm_map_key_free_F	 sm_map_key_freef;
	sm_map_data_alloc_F	 sm_map_data_allocf;
	sm_map_data_free_F	 sm_map_data_freef;
#endif /* 0 */
};

sm_ret_T sm_map_setopts(sm_map_P _map);
sm_ret_T sm_mapname_add(sm_maps_P _maps, sm_map_P _map);
sm_ret_T sm_mapname_rm(sm_maps_P _maps, sm_map_P _map);

#endif /* MAP_H */
