/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *      All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: qmibdb.c,v 1.10 2005/03/16 01:20:21 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/memops.h"
#include "sm/mta.h"
#include "sm/ibdb.h"
#include "sm/qmgr.h"
#include "sm/qmibdb.h"

/*
**  QM_IBDB_TA_FREE -- Free IBDB TA structure
**
**	Parameters:
**		ibdb_ta -- IBDB TA
**
**	Returns:
**		none.
*/

void
qm_ibdb_ta_free(ibdb_ta_P ibdb_ta)
{
	if (ibdb_ta != NULL)
	{
		SM_FREE(ibdb_ta->ibt_ta_id);
		SM_STR_FREE(ibdb_ta->ibt_mail_pa);
		SM_CSTR_FREE(ibdb_ta->ibt_cdb_id);
		sm_free_size(ibdb_ta, sizeof(*ibdb_ta));
	}
}

/*
**  IBDB_TA_FREE -- Free IBDB TA structure; callback function
**
**	Parameters:
**		value -- IBDB TA
**		key -- key (ignored, for compatibility with bhfree_F)
**		ctx -- context (ignored, for compatibility with bhfree_F)
**
**	Returns:
**		none.
*/

/* ARGSUSED1 */
void
ibdb_ta_free(void *value, void *key, void *ctx)
{
	qm_ibdb_ta_free((ibdb_ta_P) value);
}

/*
**  QM_IBDB_TA_NEW -- Create a new IBDB TA structure
**
**	Parameters:
**		pibdb_ta -- pointer to IBDB TA (output)
**
**	Returns:
**		usual sm_error code; ENOMEM
**
**	Side Effects: none on error
*/

sm_ret_T
qm_ibdb_ta_new(ibdb_ta_P *pibdb_ta)
{
	ibdb_ta_P ibdb_ta;

	SM_REQUIRE(pibdb_ta != NULL);
	ibdb_ta = (ibdb_ta_P) sm_zalloc(sizeof(*ibdb_ta));
	if (ibdb_ta == NULL)
		goto error;
	ibdb_ta->ibt_ta_id = (char *) sm_malloc(SMTP_STID_SIZE + 1);
	if (ibdb_ta->ibt_ta_id == NULL)
		goto error;
	ibdb_ta->ibt_mail_pa = sm_str_new(NULL, MAXADDRLEN, MAXADDRLEN);
	if (ibdb_ta->ibt_mail_pa == NULL)
		goto error;
	*pibdb_ta = ibdb_ta;
	return SM_SUCCESS;

  error:
	qm_ibdb_ta_free(ibdb_ta);
	*pibdb_ta = NULL;
	return sm_error_temp(SM_EM_Q_IBDB, ENOMEM);
}

/*
**  QM_IBDB_RCPT_FREE -- Free IBDB RCPT structure
**
**	Parameters:
**		ibdb_rcpt -- IBDB RCPT
**
**	Returns:
**		none.
*/

void
qm_ibdb_rcpt_free(ibdb_rcpt_P ibdb_rcpt)
{
	if (ibdb_rcpt != NULL)
	{
		SM_FREE(ibdb_rcpt->ibr_ta_id);
		SM_STR_FREE(ibdb_rcpt->ibr_pa);
		sm_free_size(ibdb_rcpt, sizeof(*ibdb_rcpt));
	}
}

/*
**  IBDB_RCPT_FREE -- Free IBDB RCPT structure; callback function
**
**	Parameters:
**		value -- IBDB RCPT
**		key -- rcpt id
**		ctx -- context (ignored, for compatibility with bhfree_F)
**
**	Returns:
**		none.
*/

/* ARGSUSED2 */
void
ibdb_rcpt_free(void *value, void *key, void *ctx)
{
	qm_ibdb_rcpt_free((ibdb_rcpt_P) value);
	sm_free((char *) key);
}

/*
**  QM_IBDB_RCPT_NEW -- Create a new IBDB RCPT structure
**
**	Parameters:
**		pibdb_rcpt -- pointer to IBDB RCPT (output)
**
**	Returns:
**		usual sm_error code; ENOMEM
**
**	Side Effects: none on error
*/

sm_ret_T
qm_ibdb_rcpt_new(ibdb_rcpt_P *pibdb_rcpt)
{
	ibdb_rcpt_P ibdb_rcpt;

	SM_REQUIRE(pibdb_rcpt != NULL);
	ibdb_rcpt = (ibdb_rcpt_P) sm_zalloc(sizeof(*ibdb_rcpt));
	if (ibdb_rcpt == NULL)
		goto error;
	ibdb_rcpt->ibr_ta_id = (char *) sm_malloc(SMTP_STID_SIZE + 1);
	if (ibdb_rcpt->ibr_ta_id == NULL)
		goto error;
	ibdb_rcpt->ibr_pa = sm_str_new(NULL, MAXADDRLEN, MAXADDRLEN);
	if (ibdb_rcpt->ibr_pa == NULL)
		goto error;
	*pibdb_rcpt = ibdb_rcpt;
	return SM_SUCCESS;

  error:
	qm_ibdb_rcpt_free(ibdb_rcpt);
	*pibdb_rcpt = NULL;
	return sm_error_temp(SM_EM_Q_IBDB, ENOMEM);
}
