/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: pmilter_applctx.c,v 1.4 2005/05/15 03:26:34 ca Exp $")
#include "sm/error.h"
#include "sm/assert.h"
#include "sm/types.h"
#include "pmilter.h"
#include "sm/pmilter.h"
#include "sm/pmfapi.h"

#if SM_USE_PMILTER

#if 0
/* get "global" context from ss context */
LIBMILTER_API void *sm_pmfi_get_ctx_g_ss(pmss_ctx_P _pmss_ctx);

/* get ss context from session context */
LIBMILTER_API void *sm_pmfi_get_ctx_ss_se(pmse_ctx_P _pmse_ctx);
#endif

/*
**  SM_PMFI_SET_CTX_G -- store "global" application context in libmilter context
**
**	Parameters:
**		pmg_ctx -- PMILTER context
**		applctx -- "global" application context to store
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_set_ctx_g(pmg_ctx_P pmg_ctx, void *applctx)
{
	SM_IS_PMG_CTX(pmg_ctx);

	pmg_ctx->pmg_appl_ctx = applctx;
	return SM_PMI_SUCCESS;
}

/*
**  SM_PMFI_GET_CTX_G -- get "global" application context from libmilter context
**
**	Parameters:
**		pmg_ctx -- PMILTER context
**
**	Returns:
**		"global" application context
*/

void *
sm_pmfi_get_ctx_g(pmg_ctx_P pmg_ctx)
{
	SM_IS_PMG_CTX(pmg_ctx);

	return pmg_ctx->pmg_appl_ctx;
}

/*
**  SM_PMFI_SET_CTX_SS -- store application context in SMTPS context
**
**	Parameters:
**		pmss_ctx -- pmilter/SMTP server context
**		applctx -- application context to store
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_set_ctx_ss(pmss_ctx_P pmss_ctx, void *applctx)
{
	SM_IS_PMSS_CTX(pmss_ctx);
	pmss_ctx->pmss_appl_ctx = applctx;
	return SM_PMI_SUCCESS;
}

/*
**  SM_PMFI_GET_CTX_SS -- get application context from libmilter context
**
**	Parameters:
**		pmss_ctx -- pmilter/SMTP server context
**
**	Returns:
**		application context
*/

void *
sm_pmfi_get_ctx_ss(pmss_ctx_P pmss_ctx)
{
	SM_IS_PMSS_CTX(pmss_ctx);
	return pmss_ctx->pmss_appl_ctx;
}

/*
**  SM_PMFI_GET_CTX_G_SS -- get "global" application context from SMTPS context
**
**	Parameters:
**		pmss_ctx -- pmilter/SMTP server context
**
**	Returns:
**		application context
*/

void *
sm_pmfi_get_ctx_g_ss(pmss_ctx_P pmss_ctx)
{
	pmg_ctx_P pmg_ctx;

	SM_IS_PMSS_CTX(pmss_ctx);
	pmg_ctx = pmss_ctx->pmss_pmg_ctx;
	SM_IS_PMG_CTX(pmg_ctx);
	return pmg_ctx->pmg_appl_ctx;
}

/*
**  SM_PMFI_SET_CTX_SE -- store session application context in session context
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**		applctx -- session application context to store
**
**	Returns:
**		usual sm_error code
*/

sm_ret_T
sm_pmfi_set_ctx_se(pmse_ctx_P pmse_ctx, void *applctx)
{
	SM_IS_PMSE_CTX(pmse_ctx);

	pmse_ctx->pmse_appl_ctx = applctx;
	return SM_PMI_SUCCESS;
}

/*
**  SM_PMFI_GET_CTX_SE -- get application context from session context
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**
**	Returns:
**		application session context
*/

void *
sm_pmfi_get_ctx_se(pmse_ctx_P pmse_ctx)
{
	SM_IS_PMSE_CTX(pmse_ctx);

	return pmse_ctx->pmse_appl_ctx;
}

/*
**  SM_PMFI_GET_CTX_SS_SE -- get application context from libmilter context
**
**	Parameters:
**		pmse_ctx -- pmilter/SMTP server session context
**
**	Returns:
**		application context
*/

void *
sm_pmfi_get_ctx_ss_se(pmse_ctx_P pmse_ctx)
{
	pmss_ctx_P pmss_ctx;

	SM_IS_PMSE_CTX(pmse_ctx);
	pmss_ctx = pmse_ctx->pmse_pmss_ctx;
	SM_IS_PMSS_CTX(pmss_ctx);
	return pmss_ctx->pmss_appl_ctx;
}

#endif /* SM_USE_PMILTER */
