/*
 * Copyright (c) 2002 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 *
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: tree-walk.c,v 1.1 2002/10/17 22:33:10 ca Exp $")

#include "sm/error.h"
#include "sm/assert.h"
#include "sm/tree.h"

/*
**  SM_TREE_WALK -- walk through a tree and apply a function
**
**	Parameters:
**		tree -- tree
**		fct -- function to apply
**		ctx -- context for function
**
**	Returns:
**		result from fct if it is an error
*/

sm_ret_T
sm_tree_walk(sm_tree_P tree, sm_tree_walk_F fct, void *ctx)
{
	sm_ret_T ret;
	sm_tree_node_P node;

	for (node = sm_tree_first(tree);
	     node != NULL;
	     node = sm_tree_next(tree, node))
	{
		ret = (*fct)(tree, node, ctx);
		if (ret != SM_SUCCESS)
			return ret;
	}
	return SM_SUCCESS;
}
