#!/bin/sh
# $Id: t-chkpidfile.sh,v 1.1 2005/08/22 05:49:51 ca Exp $
# Copyright (c) 2005 Sendmail, Inc. and its suppliers.
#	All rights reserved.
#
# By using this file, you agree to the terms and conditions set
# forth in the LICENSE file which can be found at the top level of
# the sendmail distribution.
#
# ------------------------------------------------------------
# Description:
# Test chkpidfile
# ------------------------------------------------------------
#
test -s stop && exit 1

SRV=./t-chkpidfile
PIDF=chk0.pid
L0=chk0.log
L1=chk1.log
ERRS=0

# start "server", sleep for 10s; try to start another instance
${SRV} -s 10 -f ${PIDF} -V > ${L0} 2>&1 &
P0=$!
sleep 1
if grep 'ret=0, ' ${L0} >/dev/null
then
  ${SRV} -f ${PIDF} -V > ${L1} 2>&1
  if grep 'ret=0x' ${L1} >/dev/null
  then
     wait ${P0}

  else
    echo "$0: second instance started while first is running"
    ERRS=`expr ${ERRS} + 1 `
  fi
else
  echo "$0: first instance did not start (1)"
  ERRS=`expr ${ERRS} + 1 `
fi

# start "server", sleep for 10s; kill "server", start another one
if test "X"${ERRS} = "X0"
then
  # start "server", sleep for 10s
  ${SRV} -c -s 10 -f ${PIDF} -V > ${L0} 2>&1 &
  P0=$!
  sleep 1
  if grep 'ret=0, ' ${L0} >/dev/null
  then
    kill ${P0}
    sleep 1
    ${SRV} -f ${PIDF} -V > ${L1} 2>&1
    if grep 'ret=0, ' ${L1} >/dev/null
    then
       :
    else
      echo "$0: second instance did not start after first was killed"
      ERRS=`expr ${ERRS} + 1 `
    fi
  else
    echo "$0: first instance did not start (2)"
    ERRS=`expr ${ERRS} + 1 `
  fi
fi

# start "server", sleep for 1s, unclean shutdown; start another one
if test "X"${ERRS} = "X0"
then
  # start "server", sleep for 10s
  ${SRV} -c -s 1 -f ${PIDF} -V > ${L0} 2>&1 &
  P0=$!
  sleep 1
  if grep 'ret=0, ' ${L0} >/dev/null
  then
    sleep 1
    ${SRV} -f ${PIDF} -V > ${L1} 2>&1
    if grep 'ret=0, ' ${L1} >/dev/null
    then
       :
    else
      echo "$0: second instance did not start after first terminated"
      ERRS=`expr ${ERRS} + 1 `
    fi
  else
    echo "$0: first instance did not start (3)"
    ERRS=`expr ${ERRS} + 1 `
  fi
fi

exit ${ERRS}
