/*
 * Copyright (c) 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: t-chkpidfile.c,v 1.1 2005/08/22 05:49:51 ca Exp $")
#include "sm/error.h"
#include "sm/io.h"
#include "sm/misc.h"

static int Verbosity = 0;

int
main(int argc, char *argv[])
{
	sm_ret_T ret;
	int c, fd, sl;
	bool cleanup;
	char errtxt[128];
	char pidfile[128];

	strlcpy(pidfile, "chk.pid", sizeof(pidfile));
	cleanup = true;
	sl = 1;
	while ((c = getopt(argc, argv, "cf:s:V")) != -1)
	{
		switch (c)
		{
		  case 'c':
			cleanup = false;
			break;
		  case 'f':
			strlcpy(pidfile, optarg, sizeof(pidfile));
			break;
		  case 's':
			sl = strtoul(optarg, NULL, 0);
			break;
		  case 'V':
			++Verbosity;
			break;
		}
	}
	errtxt[0] = '\0';
	ret = sm_chk_pidfile(pidfile, &fd, errtxt, sizeof(errtxt));
	if (Verbosity > 0)
		sm_io_fprintf(smioerr, "ret=%r, text=%s\n", ret, errtxt);
	sleep(sl);
	if (sm_is_success(ret) && cleanup)
	{
		close(fd);
		unlink(pidfile);
	}
	return ret;
}
