/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strsetmax.c,v 1.4 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/rpool.h"
#include "sm/str.h"
#include "sm/str-int.h"

#if SM_STR_CHECK
/*
**  SM_STR_SETMAX -- Sets the maximum length of str.
**
**	Parameters:
**		str -- sm_str_P object.
**		ml -- maximum length.
**
**	Returns:
**		0: ok
**		!= 0: error code
*/

int
sm_str_setmax(sm_str_P str, uint ml)
{
	SM_IS_BUF(str);
	if (ml < str->sm_str_size)
		return sm_error_perm(SM_EM_STR, EINVAL);
	str->sm_str_max = ml;
	return 0;
}
#endif /* SM_STR_CHECK */
