/*
 * Copyright (c) 2002, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strscopy.c,v 1.5 2005/06/09 00:43:40 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_SCOPYN -- copy n bytes from src into an existing str object.
**
**	Parameters:
**		str -- sm_str_P object to append onto.
**		src -- Byte array to copy from.
**		len -- Number of bytes to copy from src.
**
**	Returns:
**		usual sm_ret_T
*/

sm_ret_T
sm_str_scopyn(sm_str_P str, const char *src, uint len)
{
	SM_IS_BUF(str);
	SM_REQUIRE(src != NULL);

	if (len > str->sm_str_size)
		SM_STR_INCREASE_R(str, len);
	sm_memcpy(str->sm_str_base, src, len);
	str->sm_str_len = len;
	return SM_SUCCESS;
}

/*
**  SM_STR_SCOPY -- copy a char * into an existing str object.
**
**	Parameters:
**		str -- sm_str_P object to append onto.
**		char_str -- '\0' terminated str to copy.
**			trailing '\0' is not copied.
**
**	Return:
**		usual sm_ret_T
*/

sm_ret_T
sm_str_scopy(sm_str_P str, const char *src)
{

	SM_IS_BUF(str);
	SM_REQUIRE(src != NULL);

	return sm_str_scopyn(str, src, strlen(src));
}
