/*
 * Copyright (c) 2002, 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strputint.c,v 1.16 2005/06/02 19:00:37 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/error.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/str2rcb.h"
#include "sm/reccom.h"

/*
**  SM_STR_PUTUINT32 -- Append an int to the end of a sm_str_P.
**
**	Parameters:
**		str -- sm_str_P object to append onto.
**		n -- value to append.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_NS, SM_E_OVFLW_SC
*/

sm_ret_T
sm_str_putuint32(sm_str_P str, uint32_t n)
{
	uint new_alloc;

	SM_IS_BUF(str);

	new_alloc = str->sm_str_len + sizeof(int);

	/* overflow? */
	if (new_alloc <= str->sm_str_len)
		return sm_error_perm(SM_EM_STR_RCB, SM_E_OVFLW_SC);
#if SM_STR_READ
	/* do we really want to do this? */
	if (str->sm_rcb_rw >= 0 && (int) sizeof(int) > str->sm_rcb_rw)
		return sm_error_perm(SM_EM_STR_RCB, SM_E_OVFLW_NS);
#endif
	if (new_alloc > str->sm_str_size)
		SM_STR_INCREASE_R(str, new_alloc);
	sm_uint32_2buf(n, str->sm_str_base + str->sm_str_len);
	str->sm_str_len += sizeof(int);
#if SM_STR_READ
	if (str->sm_rcb_rw >= 0)
		str->sm_rcb_rw -= sizeof(int);
#endif
	return SM_SUCCESS;
}
