/*
 * Copyright (c) 2003, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strdc.c,v 1.3 2005/01/18 00:19:17 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/varargs.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"

/*
**  SM_STR_DC -- Make a copy of a str: create a new str or copy into existing
**
**	Parameters:
**		rpool -- rpool for new str
**		pdst -- (pointer to) str destination (output)
**		src -- str source
**
**	Returns:
**		usual sm_ret_T
*/

sm_ret_T
sm_str_dc(sm_rpool_P rpool, sm_str_P *pdst, const sm_str_P src)
{
	SM_IS_BUF(src);
	SM_REQUIRE(pdst != NULL);

	if (*pdst == NULL)
	{
		*pdst = sm_str_dup(rpool, src);
		if (*pdst == NULL)
			return sm_error_temp(SM_EM_STR, ENOMEM);
	}
	else
		return sm_str_cpy(*pdst, src);
	return SM_SUCCESS;
}
