/*
 * Copyright (c) 2003-2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: strcatpart.c,v 1.6 2005/08/08 17:23:10 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/limits.h"
#include "sm/strrcb.h"
#include "sm/str-int.h"
#include "sm/rdstr.h"

/*
**  SM_STR_CATPART -- Append a partial copy of src to the end of a sm_str_P.
**
**	Parameters:
**		dst -- sm_str_P object to append onto.
**		src -- sm_rdstr_P object to append.
**		first -- first index from src.
**		last -- last index from src.
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_SC, SM_E_OVFLW_NS,
**			SM_E_RANGE
*/

sm_ret_T
sm_str_catpart(sm_str_P dst, const sm_rdstr_P src, uint first, uint last)
{
	uint cpl, newl;

	SM_IS_BUF(dst);
	SM_IS_RDSTR(src);
	if (first > last || first >= SM_RDSTR_GETLEN(src) ||
	    last >= SM_RDSTR_GETLEN(src))
		return sm_error_perm(SM_EM_STR, SM_E_RANGE);
	cpl = last - first + 1;
	newl = dst->sm_str_len + cpl;
	if (newl > dst->sm_str_max || newl < dst->sm_str_len)
		return sm_error_perm(SM_EM_STR, SM_E_OVFLW_SC);
	if (newl > dst->sm_str_size)
		SM_STR_INCREASE_R(dst, newl);
	sm_memcpy(dst->sm_str_base + dst->sm_str_len,
		  SM_RDSTR_DATA(src) + first, cpl);
	dst->sm_str_len += cpl;
	return SM_SUCCESS;
}
