/*
 * Copyright (c) 2004, 2005 Sendmail, Inc. and its suppliers.
 *	All rights reserved.
 *
 * By using this file, you agree to the terms and conditions set
 * forth in the LICENSE file which can be found at the top level of
 * the sendmail distribution.
 */

#include "sm/generic.h"
SM_RCSID("@(#)$Id: rcbgetn0str.c,v 1.4 2005/06/02 19:00:36 ca Exp $")

#include "sm/assert.h"
#include "sm/magic.h"
#include "sm/memops.h"
#include "sm/rpool.h"
#include "sm/limits.h"
#include "sm/str.h"
#include "sm/str-int.h"
#include "sm/rcb.h"

/*
**  SM_RCB_GETN0STR -- Create new str object from rcb (n bytes).
**
**	Parameters:
**		rcb -- sm_rcb_P object to read from.
**		str -- (pointer to) str (output)
**		n -- number of bytes to copy (aligned to 4 bytes).
**
**	Returns:
**		usual sm_error code; ENOMEM, SM_E_OVFLW_NS
**
**	Last code review: 2005-03-29 05:32:00
**	Last code change:
*/

sm_ret_T
sm_rcb_getn0str(sm_rcb_P rcb, sm_str_P *str, uint n)
{
	uint la;	/* length of data in RCB, do NOT change! */

	SM_IS_RCB(rcb);
#if SM_RCB_CHECK
	SM_REQUIRE(rcb->sm_rcb_state == SM_RCB_DEC);
#endif
	SM_REQUIRE(str != NULL);
	la = SM_ALIGN4(n);
	if (rcb->sm_rcb_rw + la > rcb->sm_rcb_len)
		return sm_error_perm(SM_EM_RECCOM, SM_E_OVFLW_NS);

	/* make sure there is space for terminating '\0' */
	*str = sm_str_new(NULL, la + ((n == la) ? 2 : 0), la + 4);
	if (*str == NULL)
		return sm_error_temp(SM_EM_RECCOM, ENOMEM);
	sm_memcpy((void *) (*str)->sm_str_base,
		rcb->sm_rcb_base + rcb->sm_rcb_rw, n);

	/* make sure str is '\0' terminated */
	(*str)->sm_str_base[n] = '\0';
	(*str)->sm_str_len = n;
	rcb->sm_rcb_rw += la;
	return SM_SUCCESS;
}
